/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.concurrency.spec.ContextService.contextPropagate_servlet;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@WebServlet("/DeserializeServlet")
public class DeserializeServlet extends HttpServlet {

  @Override
  protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {

    try {
      Object proxy = Util.lookupDefaultContextService().createContextualProxy(new TestJNDIRunnableWork(),
          Runnable.class, TestWorkInterface.class, Serializable.class);
      ByteArrayOutputStream bout = new ByteArrayOutputStream();
      ObjectOutputStream out = new ObjectOutputStream(bout);
      out.writeObject(proxy);
      out.close();
      byte[] bytes = bout.toByteArray();
      ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
      proxy = in.readObject();
      resp.getWriter().write(proxy.toString());
    } catch (Exception e) {
      throw new ServletException(e);
    }
  }
}
