/*
 * Copyright (c) 2013, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.concurrency.spec.ManagedExecutorService.inheritedapi;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sun.ts.lib.util.TestUtil;

public class Util {

    private static final String MANAGED_EXECUTOR_SVC_JNDI_NAME = "java:comp/DefaultManagedExecutorService";

    private Util() {
    }

    public static <T> T waitForTaskComplete(final Future<T> future, final int maxTaskWaitTime)
            throws InterruptedException, ExecutionException, TimeoutException {
        T result = null;
        result = future.get(maxTaskWaitTime, TimeUnit.SECONDS);
        return result;
    }

    public static ManagedExecutorService getManagedExecutorService() {
        return lookup(MANAGED_EXECUTOR_SVC_JNDI_NAME);
    }

    public static <T> T lookup(String jndiName) {
        Context ctx = null;
        T targetObject = null;
        try {
            ctx = new InitialContext();
            targetObject = (T) ctx.lookup(jndiName);
        } catch (Exception e) {
        } finally {
            try {
                ctx.close();
            } catch (NamingException e) {
                TestUtil.logErr("failed to lookup resource.", e);
            }
        }
        return targetObject;
    }

    public static String getUrl(String servletUri, String host, int port) {
        return "http://" + host + ":" + port + Constants.CONTEXT_PATH + servletUri;
    }

}
