/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.cof.CustomFilter;
import com.sun.javatest.cof.CustomFilterAdapter;
import com.sun.javatest.cof.MTL;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class COFData {
    private Map data = new HashMap();
    private CustomFilter filter = new CustomFilterAdapter();
    private MTL mtl;
    private InterviewParameters ip;

    public COFData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    COFData(Vector data) throws IOException {
        for (int i = 0; i < data.size(); ++i) {
            Object o = data.elementAt(i);
            if (o == null) {
                throw new NullPointerException();
            }
            if (o instanceof String) {
                String s = (String)o;
                int eq = s.indexOf("=");
                if (eq < 1) {
                    throw new IllegalArgumentException(s);
                }
                String name = s.substring(0, eq);
                String value = s.substring(eq + 1);
                this.put(name, value);
                continue;
            }
            if (o instanceof File) {
                File f = (File)o;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                Properties p = new Properties();
                try {
                    p.load(in);
                }
                finally {
                    ((InputStream)in).close();
                }
                this.putAll(p);
                continue;
            }
            throw new IllegalArgumentException(o.toString());
        }
    }

    public String get(String name) {
        return (String)this.data.get(name);
    }

    public String get(String name, String defaultValue) {
        String value = (String)this.data.get(name);
        return value == null ? defaultValue : value;
    }

    public void put(String name, String value) {
        this.data.put(name, value);
    }

    public void putAll(Map map) {
        this.data.putAll(map);
    }

    void setCustomFilter(String filterClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c = Class.forName(filterClassName);
        this.filter = (CustomFilter)c.newInstance();
    }

    CustomFilter getCustomFilter() {
        return this.filter;
    }

    MTL getMtl() {
        return this.mtl;
    }

    void setMtl(MTL mtl) {
        this.mtl = mtl;
    }

    public void setInterviewParameters(InterviewParameters ip) {
        this.ip = ip;
    }

    public InterviewParameters getInterviewParameters() {
        return this.ip;
    }

    public boolean isInterviewParametersAvailable() {
        return this.ip != null;
    }
}

