/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package  com.sun.ts.lib.deliverable.servlet;

import  com.sun.ts.lib.deliverable.*;
import  com.sun.ts.lib.util.*;
import  com.sun.javatest.*;
import  java.util.*;
import  java.io.*;
import  com.sun.ts.lib.deliverable.tck.TCKPropertyManager;


/**
 * This class serves as a well known place for harness, util, and porting
 * classes to retrieve property values.
 *
 * @author
 */
public class ServletPropertyManager extends TCKPropertyManager {
    private static ServletPropertyManager jteMgr = new ServletPropertyManager();

    /**
     * This method returns
     * the singleton instance of ServletPropertyManager which provides access
     * to all ts.jte properties.  This is only called once by the test harness.
     *
     * @param	env - TestEnvironment object from JavaTest
     * @return	ServletPropertyManager - singleton property manager object
     */
    public final static ServletPropertyManager getServletPropertyManager (TestEnvironment env) throws Exception {
        jteMgr.setTestEnvironment(env);
        return  jteMgr;
    }

    /**
     * This method returns
     * the singleton instance of ServletPropertyManager which provides access
     * to all ts.jte properties.  This is only called by the init()
     * method in ManualDeployment.java
     *
     * @param	p - Properties object from JavaTest
     * @return	ServletPropertyManager - singleton property manager object
     */
    public final static ServletPropertyManager getServletPropertyManager (Properties p) throws Exception {
        jteMgr.setJteProperties(p);
        return  jteMgr;
    }

    public final static ServletPropertyManager getServletPropertyManager () throws Exception {
        return  jteMgr;
    }

    /**
     * This method is called by the test harness to retrieve all properties
     * needed by a particular test.
     *
     * @param	sPropKeys - Properties to retrieve
     * @return	Properties - property/value pairs
     */
    public Properties getTestSpecificProperties (String[] sPropKeys) throws PropertyNotSetException {
        Properties pTestProps = super.getTestSpecificProperties(sPropKeys);
        String sJtePropVal = "";
        pTestProps.put("porting.ts.url.class.1", getProperty("porting.ts.url.class.1"));
        pTestProps.put("porting.ts.HttpsURLConnection.class.1", getProperty("porting.ts.HttpsURLConnection.class.1", null));
            
	String tsHome = getProperty("TS_HOME", null);
	if(tsHome == null)
	    tsHome = getProperty("cts_home", null);
	if(tsHome != null)
            pTestProps.put("cts_home", tsHome);

        return  pTestProps;
    }
}



