/*
* Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

/*
 * $Id: TSConnectionManager.java 67280 2012-08-22 20:25:47Z phendley $
 */

package com.sun.ts.tests.common.connector.whitebox;

import javax.resource.*;
import javax.resource.spi.*;
import java.io.Serializable;

/**
 * The default ConnectionManager implementation for the
 * non-managed scenario
 *
 */
public class TSConnectionManager implements ConnectionManager, Serializable {

    public TSConnectionManager() {
    }

    @Override
    public Object allocateConnection(ManagedConnectionFactory mcf,
                                     ConnectionRequestInfo info)
        throws ResourceException {

        ManagedConnection mc = 
            mcf.createManagedConnection(null, info);

        return mc.getConnection(null, info);
    }
}
