/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)SigTestRecorder.java	1.1 03/03/05
 */
package com.sun.ts.tests.signaturetest;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.io.PrintWriter;
import java.io.File;

/**
 * <p>This implementation of {@link Recorder} will record signatures
 * using the <code>Signature Test</code> framework.</p>
 */
public class SigTestRecorder extends Recorder {


    // ------------------------------------------------------------ Constructors


    public SigTestRecorder(String[] args) {

        super(args);

    } // END SigTestRecorder


    // ------------------------------------------------------- Protected Methods


    protected String[] createCommandLine(String version,
                                         String classpath,
                                         String outputFileName,
                                         String packageName)  {

        List command = new ArrayList();

        // command.add("-xReflection");
        command.add("-static");
        command.add("-debug");
        command.add("-verbose");
        command.add("-classpath");
        command.add(classpath);

        command.add("-FileName");
        try {
            command.add(new File(outputFileName).toURI().toURL().toExternalForm());
        } catch (Exception e) {
          throw new RuntimeException(e);
        }


        command.add("-package");
        command.add(packageName);

        command.add("-apiVersion");
        command.add(version);

        String str = "Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.";
        str += "\r\n# ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.";
        command.add("-CopyRight");
        command.add(str);

        return ((String[]) command.toArray(new String[command.size()]));

    } // END getCommandLine


    protected void writePackageListFile(String basePackageName,
                                        String signatureFile,
                                        String packageListFile)
        throws Exception {

        PackageList packageList = new PackageList(basePackageName,
                                                  signatureFile,
                                                  packageListFile);
        packageList.writePkgListFile();

    } // END writePackageListFile


    protected void doRecord(String[] commandLine) throws Exception {

        Class batchSetup = Class.forName("com.sun.tdk.signaturetest.Setup");
        Object batchSetupInstance = batchSetup.newInstance();
        Method runMethod =
            batchSetup.getDeclaredMethod("run",
                                         new Class[] { String[].class,
                                                       PrintWriter.class,
                                                       PrintWriter.class });

        


        runMethod.invoke(batchSetupInstance, new Object[] { commandLine,
                                                            new PrintWriter(System.out, true),
                                                            new PrintWriter(System.err, true)});

    } // END doRecord


}  // END SigTestRecorder
