/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BasicSession;
import com.sun.javatest.exec.CustomTestResultViewer;
import com.sun.javatest.exec.ET_ControlFactory;
import com.sun.javatest.exec.ET_DefaultControlFactory;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.exec.FeatureManager;
import com.sun.javatest.exec.JavaTestContextMenu;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.exec.Session;
import com.sun.javatest.exec.ToolBarManager;
import com.sun.javatest.exec.template.ET_TemplateControlFactory;
import com.sun.javatest.exec.template.TemplateSession;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.report.Report;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ContextManager
implements InterviewParameters.TemplateManager,
Report.CustomReportManager,
BasicSession.OrderedObserver {
    protected File configLoadPath;
    protected File configSavePath;
    protected boolean configLoadOutside = true;
    protected boolean configSaveOutside = true;
    protected File templateLoadPath;
    protected File templateSavePath;
    protected boolean templateLoadOutside = true;
    protected boolean templateSaveOutside = true;
    protected File wdPath;
    protected FeatureManager featureManager = new FeatureManager();
    private WorkDirectory workdir;
    private TestSuite testSuite;
    private InterviewParameters interview;
    protected InterviewParameters currentConfig = null;
    protected InterviewParameters currentTemplate = null;
    private ExecTool parentTool;
    private Map customRenderers;
    private volatile boolean pendingRefresh = false;
    static final String TEMPLATE_ON_PROPERTY = "com.sun.javatest.exec.templateMode";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ContextManager.class);

    public JavaTestMenuManager getMenuManager() {
        return null;
    }

    public ToolBarManager getToolBarManager() {
        return new ToolBarManager();
    }

    public void dispose() {
    }

    public JavaTestContextMenu[] getContextMenus() {
        return null;
    }

    @Override
    public CustomReport[] getCustomReports() {
        return null;
    }

    public CustomTestResultViewer[] getCustomResultViewers() {
        return null;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public WorkDirectory getWorkDirectory() {
        return this.workdir;
    }

    public InterviewParameters getInterview() {
        return this.getCurrentInterview();
    }

    public InterviewParameters getTemplate() throws IOException, Interview.Fault {
        if (this.interview == null) {
            return null;
        }
        if (this.interview.isTemplate()) {
            return this.interview;
        }
        InterviewParameters template = null;
        if (this.interview.getTemplatePath() != null && this.workdir != null) {
            File f = new File(this.interview.getTemplatePath());
            template = InterviewParameters.open(f, this.workdir);
        }
        return template;
    }

    public InterviewParameters getCurrentInterview() {
        return this.currentConfig;
    }

    public InterviewParameters getCurrentTemplate() {
        return this.currentTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTests() {
        ContextManager contextManager = this;
        synchronized (contextManager) {
            if (this.pendingRefresh) {
                return;
            }
            this.pendingRefresh = true;
        }
        if (EventQueue.isDispatchThread()) {
            Runnable cmd = new Runnable(){

                @Override
                public void run() {
                    ContextManager.this.refreshTestsImpl();
                }
            };
            Thread t = new Thread(cmd, "ContextMgr Refresh Defer");
            t.start();
            return;
        }
        this.refreshTestsImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTestsImpl() {
        ContextManager contextManager = this;
        synchronized (contextManager) {
            this.pendingRefresh = false;
        }
        if (this.parentTool != null) {
            TestResultTable trt = this.parentTool.getActiveTestResultTable();
            HashMap pathMap = new HashMap();
            this.parentTool.saveTreeState(pathMap);
            if (trt != null) {
                try {
                    this.parentTool.pauseTreeCacheWork();
                    trt.getLock().lock();
                    trt.waitUntilReady();
                    trt.refreshIfNeeded(trt.getRoot());
                }
                catch (TestResultTable.Fault fault) {
                }
                finally {
                    trt.getLock().unlock();
                    this.parentTool.unpauseTreeCacheWork();
                }
            }
            this.parentTool.restoreTreeState(pathMap);
        }
    }

    public void syncInterview() {
        this.parentTool.syncInterview();
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public void setFeatureManager(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    @Override
    public boolean canSaveTemplate(File file) {
        return true;
    }

    public void setDefaultWorkDirPath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.wdPath = dir;
    }

    public File getDefaultWorkDirPath() {
        return this.wdPath;
    }

    public void setDefaultTemplateLoadPath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.templateLoadPath = dir;
    }

    public File getDefaultTemplateLoadPath() {
        return this.templateLoadPath;
    }

    public void setDefaultTemplateSavePath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.templateSavePath = dir;
    }

    public File getDefaultTemplateSavePath() {
        return this.templateSavePath;
    }

    public void setAllowTemplateLoadOutsideDefault(boolean state) {
        this.templateLoadOutside = state;
    }

    public boolean getAllowTemplateLoadOutsideDefault() {
        return this.templateLoadOutside;
    }

    public void setAllowTemplateSaveOutsideDefault(boolean state) {
        this.templateSaveOutside = state;
    }

    public boolean getAllowTemplateSaveOutsideDefault() {
        return this.templateSaveOutside;
    }

    public void setDefaultConfigLoadPath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.configLoadPath = dir;
    }

    public File getDefaultConfigLoadPath() {
        return this.configLoadPath;
    }

    public void setDefaultConfigSavePath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.configSavePath = dir;
    }

    public File getDefaultConfigSavePath() {
        return this.configSavePath;
    }

    public void setAllowConfigLoadOutsideDefault(boolean state) {
        this.configLoadOutside = state;
    }

    public boolean getAllowConfigLoadOutsideDefault() {
        return this.configLoadOutside;
    }

    public void setAllowConfigSaveOutsideDefault(boolean state) {
        this.configSaveOutside = state;
    }

    public boolean getAllowConfigSaveOutsideDefault() {
        return this.configSaveOutside;
    }

    public void loadConfiguration(File file) {
        this.parentTool.loadInterview(file);
    }

    protected void setWorkDir(WorkDirectory w) {
        this.setWorkDirectory(w);
    }

    protected void setWorkDirectory(WorkDirectory w) {
        this.workdir = w;
    }

    protected void openTree(WorkDirectory wd) {
    }

    protected void setTestSuite(TestSuite ts) {
        this.testSuite = ts;
    }

    public Map getCustomRenderersMap() {
        return this.customRenderers;
    }

    protected void registerCustomQuestionRenderer(Class<? extends Question> question, QuestionRenderer renderer) {
        if (this.customRenderers == null) {
            this.customRenderers = new HashMap();
        }
        this.customRenderers.put(question, renderer);
    }

    public ET_ControlFactory getExecToolControlFactory(ExecTool et, UIFactory uif) {
        if (Boolean.parseBoolean(System.getProperty(TEMPLATE_ON_PROPERTY))) {
            return new ET_TemplateControlFactory(et, uif, this.testSuite, this, et, et);
        }
        return new ET_DefaultControlFactory(et, uif, this.testSuite, this, et, et);
    }

    @Override
    public void updated(Session.Event ev) {
        if (ev instanceof BasicSession.E_NewWD) {
            this.updatedWorkDirectory(((BasicSession.E_NewWD)ev).wd);
        } else if (ev instanceof BasicSession.E_NewConfig) {
            this.updatedCurrentConfig(((BasicSession.E_NewConfig)ev).ip);
        } else if (ev instanceof TemplateSession.E_NewTemplate) {
            this.updatedCurrentTemplate(((TemplateSession.E_NewTemplate)ev).templ);
        }
    }

    @Override
    public int order() {
        return 2147483547;
    }

    protected void updatedWorkDirectory(WorkDirectory wd) {
        this.setWorkDirectory(wd);
    }

    protected void updatedCurrentConfig(InterviewParameters ip) {
    }

    protected void updatedCurrentTemplate(InterviewParameters ip) {
    }

    void setInterview(InterviewParameters i) {
        this.interview = i;
    }

    void setCurrentConfig(Session conf) {
        if (conf instanceof BasicSession) {
            BasicSession bc = (BasicSession)conf;
            this.setWorkDirectory(bc.wd);
            this.currentConfig = bc.config;
        }
        if (conf instanceof TemplateSession) {
            this.currentTemplate = ((TemplateSession)conf).getTemplate();
        }
    }

    void setTool(ExecTool t) {
        this.parentTool = t;
    }

    public static abstract class TestManagerDialog
    extends ToolDialog {
        public TestManagerDialog(ContextManager context, UIFactory uif, String key) {
            super(context.parentTool, uif, key);
        }
    }
}

