/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

/*
 * $Id: VectELResolver.java 62555 2011-04-15 18:14:08Z dougd $
 */

package com.sun.ts.tests.el.common.elresolver;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import java.util.Iterator;
import java.util.Vector;

/* This simple EL Resolver resolves only method expressions of
   the form ${vect.methodName}, where 'vect' is resolved to java.util.Vector
   and 'methodName' is one of its methods.
*/

public class VectELResolver extends ELResolver
{

    public Object getValue(ELContext context, Object base, Object property)
        throws ELException
    {
        if (context == null) throw new NullPointerException();

        if (base == null && "vect".equals(property)) {
	    context.setPropertyResolved(true);
	    return new Vector();
	}
        return null;
    }

    public Class getType(ELContext context, Object base, Object property)
        throws ELException
    {
        if (context == null) throw new NullPointerException();

        if (base == null && "vect".equals(property)) 
	    context.setPropertyResolved(true);

        // we never set a value
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value)
    {   
        if (context == null) throw new NullPointerException();

        if (base == null && "vect".equals(property))
	    context.setPropertyResolved(true);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property)
    {
        if (context == null) throw new NullPointerException();

        if (base == null && "vect".equals(property)) 
	    context.setPropertyResolved(true);
        return true;
    }

    public Iterator getFeatureDescriptors(ELContext context, Object base) 
    {
        return null;
    }

    public Class getCommonPropertyType(ELContext context, Object base)
    {
        return null;      
    }
}
