/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.DirectoryFileFilter;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.YesNoQuestion;
import com.sun.jck.interview.DevtoolsJaxbInterview;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.Map;

class DevtoolsJaxbClassesInterview
extends JCKEnvInterview {
    private final DevtoolsJaxbInterview parent;
    final Question q_intro1 = new NullQuestion(this, "intro1"){

        public Question getNext() {
            TestPlatformInterview testPlatformInterview = DevtoolsJaxbClassesInterview.this.parent.getDevtoolsInterview().getTestPlatformInterview();
            if (testPlatformInterview.isMultiJVM()) {
                return DevtoolsJaxbClassesInterview.this.q_needJaxbClasses;
            }
            return DevtoolsJaxbClassesInterview.this.q_final;
        }

        public boolean isHidden() {
            return true;
        }
    };
    final Question q_needJaxbClasses = new YesNoQuestion(this, "needJaxbClasses"){

        public Question getNext() {
            if (this.getValue() == null) {
                return null;
            }
            if ("No".equals(this.getValue())) {
                return DevtoolsJaxbClassesInterview.this.q_final;
            }
            return DevtoolsJaxbClassesInterview.this.q_jaxbClasses;
        }

        public boolean isHidden() {
            boolean bl = DevtoolsJaxbClassesInterview.this.parent.getDevtoolsInterview().isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "No";
        }
    };
    final Question q_jaxbClasses = new FileListQuestion(this, "jaxbClasses"){
        {
            FileFilter[] fileFilterArray = new FileFilter[]{new DirectoryFileFilter("Directories"), new ExtensionFileFilter(".zip", "ZIP Files"), new ExtensionFileFilter(".jar", "JAR Files")};
            this.setFilters(fileFilterArray);
            this.setDefaultValue(null);
        }

        public Question getNext() {
            return DevtoolsJaxbClassesInterview.this.q_final;
        }

        public void export(Map map) {
            TestPlatformInterview testPlatformInterview = DevtoolsJaxbClassesInterview.this.parent.getDevtoolsInterview().getTestPlatformInterview();
            char c = testPlatformInterview.getPathSep();
            File[] fileArray = this.getValue();
            String string = Utils.constructClasspath(fileArray, c);
            map.put("jaxbClasses", string);
        }
    };
    final Question q_final = new FinalQuestion(this);

    DevtoolsJaxbClassesInterview(DevtoolsJaxbInterview devtoolsJaxbInterview) {
        super(devtoolsJaxbInterview, "classes");
        this.parent = devtoolsJaxbInterview;
        this.setFirstQuestion(this.q_intro1);
    }
}

