/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.DirectoryFileFilter;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.jck.interview.DevtoolsInterview;
import com.sun.jck.interview.GroupModeSupport;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.ServicesInterview;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.Map;

class DevtoolsTestedJavaInterview
extends JCKEnvInterview {
    static final String CP_ENV = "environment variable";
    static final String CP_OPT = "command line option";
    final GroupModeSupport groupModeSupport;
    private DevtoolsInterview parent;
    Question qStart = new NullQuestion(this, "intro"){

        public boolean isHidden() {
            return true;
        }

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = DevtoolsTestedJavaInterview.this.parent.getTestPlatformInterview();
            return testPlatformInterview.isLocal() ? DevtoolsTestedJavaInterview.this.qCmdAsFile : DevtoolsTestedJavaInterview.this.qCmdAsString;
        }
    };
    FileQuestion qCmdAsFile = new FileQuestion(this, "cmdAsFile"){

        protected Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            if (!DevtoolsTestedJavaInterview.this.parent.getTestPlatformInterview().isGroupMode()) {
                return DevtoolsTestedJavaInterview.this.qEnd;
            }
            if (DevtoolsTestedJavaInterview.this.parent.getRootInterview().isErrorCheckingEnabled() && !this.value.isFile()) {
                return DevtoolsTestedJavaInterview.this.qNoFileError;
            }
            return DevtoolsTestedJavaInterview.this.qClassPath;
        }

        public void export(Map map) {
            ServicesInterview servicesInterview = DevtoolsTestedJavaInterview.this.parent.getServicesInterview();
            servicesInterview.exportJavaHome(this.value.getPath(), map);
        }
    };
    private StringQuestion qCmdAsString = new StringQuestion(this, "cmdAsString"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            if (!DevtoolsTestedJavaInterview.this.parent.getTestPlatformInterview().isGroupMode()) {
                return DevtoolsTestedJavaInterview.this.qEnd;
            }
            return DevtoolsTestedJavaInterview.this.qClassPath;
        }

        public void export(Map map) {
            ServicesInterview servicesInterview = DevtoolsTestedJavaInterview.this.parent.getServicesInterview();
            servicesInterview.exportJavaHome(this.value, map);
        }
    };
    ChoiceQuestion qClassPath = new ChoiceQuestion(this, "classpath"){
        {
            this.setChoices(new String[]{null, DevtoolsTestedJavaInterview.CP_ENV, DevtoolsTestedJavaInterview.CP_OPT});
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (DevtoolsTestedJavaInterview.CP_ENV.equals(this.value)) {
                return DevtoolsTestedJavaInterview.this.qClassPathEnv;
            }
            return DevtoolsTestedJavaInterview.this.qClassPathOpt;
        }
    };
    StringQuestion qClassPathEnv = new StringQuestion(this, "classpathEnv"){
        {
            this.setSuggestions(new String[]{"", "CLASSPATH"});
        }

        protected Question getNext() {
            TestPlatformInterview testPlatformInterview = DevtoolsTestedJavaInterview.this.parent.getTestPlatformInterview();
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return DevtoolsTestedJavaInterview.this.qAdditionalClasspath;
        }
    };
    StringQuestion qClassPathOpt = new StringQuestion(this, "classpathOpt"){
        {
            this.setSuggestions(new String[]{"", "-classpath #", "/cp:#"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0 || this.value.indexOf("#") == -1) {
                return null;
            }
            return DevtoolsTestedJavaInterview.this.qAdditionalClasspath;
        }
    };
    StringQuestion qOtherEnvVars = new StringQuestion(this, "otherEnvVars"){

        protected Question getNext() {
            return DevtoolsTestedJavaInterview.this.qOtherOpts;
        }
    };
    StringQuestion qOtherOpts = new StringQuestion(this, "otherOpts"){

        protected Question getNext() {
            return DevtoolsTestedJavaInterview.this.qEnd;
        }
    };
    FileListQuestion qAdditionalClasspath = new FileListQuestion(this, "additionalClasspath"){
        {
            FileFilter[] fileFilterArray = new FileFilter[]{new DirectoryFileFilter("Directories"), new ExtensionFileFilter(".zip", "ZIP Files"), new ExtensionFileFilter(".jar", "JAR Files")};
            this.setFilters(fileFilterArray);
            this.setDefaultValue(null);
        }

        public File getBaseDirectory() {
            return new File(System.getProperty("user.dir"));
        }

        protected Question getNext() {
            return DevtoolsTestedJavaInterview.this.qOtherEnvVars;
        }
    };
    final String AGENT_CMD = "$xjc_agent_command $xjc_agent_passive_host $xjc_agent_passive_port $xjc_use_map_file";
    static final String CLASSPATH = "$testSuiteRootDir$/classes$:${jaxbClasses}$:$testSuiteRootDir$/lib$/jtjck.jar$:$testSuiteRootDir$/lib$/javatest.jar";
    private ErrorQuestion qNoFileError = new ErrorQuestion(this, "noFileError");
    private FinalQuestion qEnd = new FinalQuestion(this);

    DevtoolsTestedJavaInterview(DevtoolsInterview devtoolsInterview) {
        super(devtoolsInterview, "testExecute");
        this.parent = devtoolsInterview;
        this.groupModeSupport = new GroupModeSupport(this);
        this.setFirstQuestion(this.qStart);
    }

    void exportForGroupMode(boolean bl, Map map, String string, String string2) {
        map.put("java_path", Utils.adjust(this.getJavaCmd()));
        if (bl) {
            map.put(string + ".isGroupMode", String.valueOf(this.groupModeSupport.isGroupModeEnabled()));
        }
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        File[] fileArray = this.qAdditionalClasspath.getValue();
        String string3 = CLASSPATH;
        String string4 = Utils.constructClasspath(fileArray, testPlatformInterview.getPathSep());
        if (string4 != null && string4.trim().length() > 0) {
            string3 = CLASSPATH + testPlatformInterview.getPathSep() + string4;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (testPlatformInterview.isUseAgent()) {
            stringBuffer.append("$xjc_agent_command $xjc_agent_passive_host $xjc_agent_passive_port $xjc_use_map_file");
            stringBuffer.append(' ');
        }
        if (bl) {
            this.groupModeSupport.appendArguments(stringBuffer);
        } else {
            stringBuffer.append("com.sun.javatest.lib.ProcessCommand ");
        }
        String string5 = DevtoolsInterview.parseEnvVars(this.qOtherEnvVars.getStringValue());
        int n = stringBuffer.length();
        if (CP_ENV.equals(this.qClassPath.getValue())) {
            stringBuffer.append(this.qClassPathEnv.getValue());
            stringBuffer.append('=');
            stringBuffer.append(string3);
            stringBuffer.append(' ');
        }
        if (string5 != null && !string5.isEmpty()) {
            stringBuffer.append(string5);
            stringBuffer.append(' ');
        }
        if (n < stringBuffer.length() && bl && bl) {
            stringBuffer.insert(n, "-MENV_ ");
        }
        if (bl) {
            stringBuffer.append("-MCMD_ ");
        }
        stringBuffer.append(Utils.adjust(this.getJavaCmd()));
        stringBuffer.append(' ');
        if (this.qOtherOpts.getValue() != null && this.qOtherOpts.getValue().length() > 0) {
            stringBuffer.append(this.qOtherOpts.getValue());
            stringBuffer.append(' ');
        }
        if (CP_OPT.equals(this.qClassPath.getValue())) {
            stringBuffer.append(Utils.evalTemplate(this.qClassPathOpt.getValue(), string3));
            stringBuffer.append(' ');
        }
        if (bl) {
            stringBuffer.append("-MTEST_ ");
        }
        stringBuffer.append(string2);
        if (bl) {
            map.put("command." + string + ".group", stringBuffer.toString());
        } else {
            map.put("command." + string, stringBuffer.toString());
        }
    }

    public String getJavaCmd() {
        TestPlatformInterview testPlatformInterview = this.parent.getTestPlatformInterview();
        return testPlatformInterview.isLocal() ? this.qCmdAsFile.getStringValue() : this.qCmdAsString.getValue();
    }
}

