/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.Checklist;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Question;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKIntQuestion;
import com.sun.jck.interview.JCKStringQuestion;
import com.sun.jck.interview.RuntimeInterview;
import com.sun.jck.interview.RuntimeNetworkInterview;
import com.sun.jck.interview.ServicesInterview;
import com.sun.jck.interview.Utils;
import java.util.Map;

class RuntimeIDLInterview
extends JCKEnvInterview {
    private JCKStringQuestion qORBHost = new JCKStringQuestion(this, "orbHost"){
        {
            this.setSuggestions(new String[]{this.getDefValue()});
        }

        public void export(Map map) {
            map.put("ORBHost", RuntimeIDLInterview.this.qORBHost.getValue());
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeIDLInterview.this.qORBPort;
        }

        public boolean isHidden() {
            boolean bl = RuntimeIDLInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return RuntimeNetworkInterview.getLocalhostName();
        }
    };
    private JCKIntQuestion qORBPort = new JCKIntQuestion(this, "orbPort", 0, 65535){
        {
            this.setSuggestions(new int[]{this.getDefValue()});
        }

        protected Question getNext() {
            if (!this.isValid()) {
                return null;
            }
            if (!RuntimeIDLInterview.this.qORBService.isHidden()) {
                return RuntimeIDLInterview.this.qORBService;
            }
            return RuntimeIDLInterview.this.qEnd;
        }

        public void export(Map map) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("-ORBInitialHost ");
            stringBuffer.append(RuntimeIDLInterview.this.qORBHost.getValue());
            stringBuffer.append(' ');
            stringBuffer.append("-ORBInitialPort ");
            stringBuffer.append(String.valueOf(RuntimeIDLInterview.this.qORBPort.getValue()));
            stringBuffer.append(' ');
            stringBuffer.append("-initType 2");
            stringBuffer.append(' ');
            stringBuffer.append("-classDir $testClassDir");
            map.put("StdIDLArgs", stringBuffer.toString());
            map.put("ORBPort", String.valueOf(RuntimeIDLInterview.this.qORBPort.getValue()));
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item;
            Checklist.Item[] itemArray = new Checklist.Item[1];
            Object[] objectArray = new Object[]{Integer.toString(RuntimeIDLInterview.this.qORBPort.getValue()), RuntimeIDLInterview.this.qORBHost.getValue()};
            itemArray[0] = item = RuntimeIDLInterview.this.createChecklistItem("idlSection", "idlResource", objectArray);
            return itemArray;
        }

        public boolean isHidden() {
            boolean bl = RuntimeIDLInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private int getDefValue() {
            return 1050;
        }
    };
    private JCKStringQuestion qORBService = new JCKStringQuestion(this, "orbService"){
        {
            String string2 = String.format("%1$s/bin/tnameserv -ORBInitialPort %2$s", "@{java.home}", "@{port}");
            this.setSuggestions(new String[]{"", string2});
        }

        public void export(Map map) {
            if (this.getValue() == null) {
                return;
            }
            map.put("tnamerserv.command", Utils.adjustForSpace(this.getValue()));
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeIDLInterview.this.qEnd;
        }

        public boolean isHidden() {
            ServicesInterview servicesInterview = RuntimeIDLInterview.this.parent.getServicesInterview();
            if (!servicesInterview.areServicesOn()) {
                return true;
            }
            return !servicesInterview.needOrb();
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview parent;

    RuntimeIDLInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "idl");
        this.parent = runtimeInterview;
        this.setFirstQuestion(this.qORBHost);
    }

    public void export(Map map) {
        super.export(map);
        if (this.parent.isSimple()) {
            if (this.qORBHost.isHidden()) {
                this.qORBHost.export(map);
            }
            if (this.qORBPort.isHidden()) {
                this.qORBPort.export(map);
            }
        }
    }
}

