/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.Checklist;
import com.sun.interview.FinalQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.javatest.TestSuite;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKYesNoQuestion;
import com.sun.jck.interview.RuntimeInterview;
import java.io.File;
import java.util.Map;

class RuntimeURLInterview
extends JCKEnvInterview {
    private Question qHttpURL = new StringQuestion(this, "httpURL"){
        {
            this.setSuggestions(new String[]{"", "http://www.example.org/index.html"});
        }

        protected void export(Map map) {
            map.put("httpURL", this.value);
            map.put("network.httpURL", this.value);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeURLInterview.this.qFtpURL;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item;
            Checklist.Item[] itemArray = new Checklist.Item[1];
            String string = this.value;
            itemArray[0] = item = RuntimeURLInterview.this.createChecklistItem("urlSection", "urlHTTPResource", string);
            return itemArray;
        }
    };
    private Question qFtpURL = new StringQuestion(this, "ftpURL"){
        {
            this.setSuggestions(new String[]{"", "ftp://ftp.w3.org/welcome.msg"});
        }

        protected void export(Map map) {
            map.put("ftpURL", this.value);
            map.put("network.ftpURL", this.value);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeURLInterview.this.qNeedProxy;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item;
            Checklist.Item[] itemArray = new Checklist.Item[1];
            String string = this.value;
            itemArray[0] = item = RuntimeURLInterview.this.createChecklistItem("urlSection", "urlFTPResource", string);
            return itemArray;
        }
    };
    private JCKYesNoQuestion qNeedProxy = new JCKYesNoQuestion(this, "needProxy"){

        public void export(Map map) {
            if (this.value == "Yes") {
                map.put("jckHTTPProxyHost", RuntimeURLInterview.this.qProxyHost.getValue());
                map.put("network.jckHTTPProxyHost", RuntimeURLInterview.this.qProxyHost.getValue());
                map.put("jckHTTPProxyPort", String.valueOf(RuntimeURLInterview.this.qProxyPort.getValue()));
                map.put("network.jckHTTPProxyPort", String.valueOf(RuntimeURLInterview.this.qProxyPort.getValue()));
            } else {
                map.put("jckHTTPProxyHost", "NONE");
                map.put("network.jckHTTPProxyHost", "NONE");
                map.put("jckHTTPProxyPort", "NONE");
                map.put("network.jckHTTPProxyPort", "NONE");
            }
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return RuntimeURLInterview.this.qProxyHost;
            }
            return RuntimeURLInterview.this.qFileURL;
        }

        public boolean isHidden() {
            boolean bl = RuntimeURLInterview.this.iRuntime.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "No";
        }
    };
    private StringQuestion qProxyHost = new StringQuestion(this, "proxyHost"){

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeURLInterview.this.qProxyPort;
        }
    };
    private IntQuestion qProxyPort = new IntQuestion(this, "proxyPort", 0, 65535){

        protected Question getNext() {
            if (this.isValid()) {
                return RuntimeURLInterview.this.qFileURL;
            }
            return null;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item;
            Checklist.Item[] itemArray = new Checklist.Item[1];
            Object[] objectArray = new Object[]{Integer.toString(RuntimeURLInterview.this.qProxyPort.getValue()), RuntimeURLInterview.this.qProxyHost.getValue()};
            itemArray[0] = item = RuntimeURLInterview.this.createChecklistItem("urlSection", "urlProxyResource", objectArray);
            return itemArray;
        }
    };
    private Question qFileURL = new StringQuestion(this, "fileURL"){

        protected void export(Map map) {
            map.put("fileURL", this.value);
            map.put("network.fileURL", this.value);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return RuntimeURLInterview.this.qEnd;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item;
            Checklist.Item[] itemArray = new Checklist.Item[1];
            String string = this.value;
            itemArray[0] = item = RuntimeURLInterview.this.createChecklistItem("urlSection", "urlFileResource", string);
            return itemArray;
        }

        public String[] getSuggestions() {
            String string;
            String[] stringArray = super.getSuggestions();
            boolean bl = RuntimeURLInterview.this.iRuntime.isSimple();
            if (stringArray == null && bl && !this.isHidden() && (string = this.getDefValue()) != null) {
                return new String[]{string};
            }
            return new String[]{"", "file:///etc/hosts", "file:///C:\\AUTOEXEC.BAT"};
        }

        private String getDefValue() {
            File file;
            TestSuite testSuite = RuntimeURLInterview.this.iRuntime.getRootInterview().getTestSuite();
            File file2 = file = testSuite == null ? null : testSuite.getRootDir();
            if (file == null) {
                return null;
            }
            try {
                File file3 = new File(file, "testsuite.jtt");
                return file3.toURI().toString();
            }
            catch (Exception exception) {
                return null;
            }
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview iRuntime;

    RuntimeURLInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "url");
        this.iRuntime = runtimeInterview;
        this.setFirstQuestion(this.qHttpURL);
    }

    public void export(Map map) {
        if (this.iRuntime.isSimple() && this.qNeedProxy.isHidden()) {
            this.qNeedProxy.export(map);
        }
    }
}

