/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.jck.lib.ScriptGenCommand;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerAPICommand
extends Command
implements ScriptGenCommand {
    protected static final Status COMPILATION_PASSED = Status.passed("Compilation successful");
    protected static final Status COMPILATION_FAILED = Status.failed("Compilation failed");
    private String classPath;
    protected String outDir;
    private String srcOutDir;
    private String processor;
    private String[] testSource;
    private List<String> otherOpts;
    private Map<String, String> processorOpts = new HashMap<String, String>();
    private String compilerClass;
    private boolean inputClassMode = false;
    private String srcDir;
    protected List<? extends File> cpList;

    protected final void decodeAllArgs(String[] stringArray) {
        int n;
        for (int i = 0; i < stringArray.length; i += n) {
            n = this.decodeArg(stringArray, i);
            if (n != 0) continue;
            throw new IllegalArgumentException("Could not recognize argument: " + stringArray[i]);
        }
    }

    protected int decodeArg(String[] stringArray, int n) {
        if ((stringArray[n].equals("-cp") || stringArray[n].equals("-classpath")) && n + 1 < stringArray.length) {
            this.classPath = stringArray[n + 1];
            this.cpList = CompilerAPICommand.splitLocation(this.classPath, File.pathSeparator);
            return 2;
        }
        if (stringArray[n].equals("-d") && n + 1 < stringArray.length) {
            this.outDir = stringArray[n + 1];
            return 2;
        }
        if (stringArray[n].equals("-srcDir") && n + 1 < stringArray.length) {
            this.srcDir = stringArray[n + 1];
            return 2;
        }
        if (stringArray[n].equals("-s") && n + 1 < stringArray.length) {
            this.srcOutDir = stringArray[n + 1];
            return 2;
        }
        if (stringArray[n].equals("-processor") && n + 1 < stringArray.length) {
            this.processor = stringArray[n + 1];
            return 2;
        }
        if (stringArray[n].startsWith("-A")) {
            int n2 = stringArray[n].indexOf(61);
            if (n2 == -1) {
                this.processorOpts.put(stringArray[n].substring(2), null);
            } else {
                this.processorOpts.put(stringArray[n].substring(2, n2), stringArray[n].substring(n2 + 1));
            }
            return 1;
        }
        if (stringArray[n].equals("-class") && n + 1 < stringArray.length) {
            this.compilerClass = stringArray[n + 1];
            return 2;
        }
        if (stringArray[n].startsWith("-inputClassMode") && n < stringArray.length) {
            this.inputClassMode = true;
            return 1;
        }
        if (stringArray[n].equals("-optStart") && n + 1 < stringArray.length) {
            int n3 = CompilerAPICommand.simpleSearch(stringArray, "-optEnd", n);
            if (n3 == -1) {
                throw new IllegalArgumentException("-optStart without -optEnd");
            }
            if (n3 <= n - 1) {
                throw new IllegalArgumentException("Invalid position -optEnd");
            }
            int n4 = n3 - n - 1;
            String[] stringArray2 = new String[n4];
            System.arraycopy(stringArray, n + 1, stringArray2, 0, n4);
            this.otherOpts = Arrays.asList(stringArray2);
            return 2 + n4;
        }
        this.testSource = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, this.testSource, 0, stringArray.length - n);
        return stringArray.length - n;
    }

    private static int simpleSearch(String[] stringArray, String string, int n) {
        for (int i = n; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public void printArgs() {
        System.out.println("classPath=" + this.classPath);
        System.out.println("outDir=" + this.outDir);
        System.out.println("srcOutDir=" + this.srcOutDir);
        System.out.println("processor=" + this.processor);
        System.out.println("processorOpts=" + this.processorOpts);
        System.out.println("otherOptions=" + this.otherOpts);
        System.out.println("compilerClass=" + this.compilerClass);
        System.out.println("testSource=" + Arrays.toString(this.testSource));
        System.out.println("srcDir=" + this.srcDir);
        System.out.println("inputClassMode=" + this.inputClassMode);
    }

    protected JavaCompiler getCompiler() {
        if (this.compilerClass != null) {
            ServiceLoader<JavaCompiler> serviceLoader = ServiceLoader.load(JavaCompiler.class);
            for (JavaCompiler javaCompiler : serviceLoader) {
                if (!this.compilerClass.equals(javaCompiler.getClass().getName())) continue;
                return javaCompiler;
            }
            throw new IllegalArgumentException("Compiler class is not found: className=" + this.compilerClass + " loader=" + serviceLoader);
        }
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            throw new RuntimeException("Default compiler is not available");
        }
        return javaCompiler;
    }

    private static List<? extends File> splitLocation(String string, String string2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(new File((String)stringTokenizer.nextElement()));
        }
        return arrayList;
    }

    private static URL[] filesToURLs(Iterable<? extends File> iterable) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file : iterable) {
            arrayList.add(file.toURI().toURL());
        }
        return arrayList.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        this.decodeAllArgs(stringArray);
        boolean bl = false;
        try {
            JavaCompiler javaCompiler = this.getCompiler();
            StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
            try {
                bl = this.doCompile(javaCompiler, standardJavaFileManager, printWriter2);
            }
            finally {
                standardJavaFileManager.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(printWriter2);
            return Status.error(throwable.toString());
        }
        return bl ? COMPILATION_PASSED : COMPILATION_FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doCompile(JavaCompiler javaCompiler, StandardJavaFileManager standardJavaFileManager, PrintWriter printWriter) throws IOException {
        StandardJavaFileManager standardJavaFileManager2 = standardJavaFileManager;
        synchronized (standardJavaFileManager2) {
            Iterable<? extends JavaFileObject> iterable = null;
            List<String> list = null;
            if (this.inputClassMode) {
                list = Arrays.asList(this.testSource);
            } else {
                iterable = this.getCompilationUnits(standardJavaFileManager);
            }
            if (this.cpList != null) {
                standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, this.cpList);
                if (this.processor != null) {
                    standardJavaFileManager.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, this.cpList);
                }
            }
            if (this.outDir != null) {
                standardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(new File(this.outDir)));
            }
            if (this.srcOutDir != null) {
                standardJavaFileManager.setLocation(StandardLocation.SOURCE_OUTPUT, Collections.singleton(new File(this.srcOutDir)));
            }
            Collector collector = new Collector(printWriter);
            JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(printWriter, standardJavaFileManager, collector, this.otherOpts, list, iterable);
            if (this.processor != null) {
                compilationTask.setProcessors(this.getProcessors());
            }
            boolean bl = compilationTask.call();
            collector.printSummary();
            collector.checkDiagnostics(bl);
            return bl;
        }
    }

    protected Iterable<? extends JavaFileObject> getCompilationUnits(StandardJavaFileManager standardJavaFileManager) {
        if (this.srcDir == null) {
            return standardJavaFileManager.getJavaFileObjectsFromStrings(Arrays.asList(this.testSource));
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : this.testSource) {
            File file = new File(this.srcDir, string);
            arrayList.add(file);
        }
        return standardJavaFileManager.getJavaFileObjectsFromFiles(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Status status;
        PrintWriter printWriter = new PrintWriter(System.out);
        PrintWriter printWriter2 = new PrintWriter(System.err);
        try {
            CompilerAPICommand compilerAPICommand = new CompilerAPICommand();
            status = compilerAPICommand.run(stringArray, printWriter, printWriter2);
        }
        finally {
            printWriter.close();
            printWriter2.close();
        }
        if (status.isPassed()) {
            System.exit(0);
        } else {
            System.exit(status.isFailed() ? 1 : 2);
        }
    }

    protected List<? extends Processor> getProcessors() {
        try {
            ArrayList<Processor> arrayList = new ArrayList<Processor>();
            ClassLoader classLoader = this.cpList != null ? new URLClassLoader(CompilerAPICommand.filesToURLs(this.cpList), this.getClass().getClassLoader()) : this.getClass().getClassLoader();
            for (String string : this.processor.split(";")) {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
                Processor processor = (Processor)clazz.newInstance();
                this.setProcessorOptions(processor);
                arrayList.add(processor);
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error initilizing processors (processor=" + this.processor + ";processorOpts=" + this.processorOpts + ")", exception);
        }
    }

    private void setProcessorOptions(Processor processor) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] classArray = new Class[]{Map.class};
        try {
            Method method = processor.getClass().getMethod("setProcessorOpts", classArray);
            method.invoke((Object)processor, this.processorOpts);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public String[] getCommandLine(String[] stringArray) {
        this.decodeAllArgs(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("{{javac}}");
        if (this.classPath != null) {
            arrayList.add("-cp");
            arrayList.add(this.classPath);
        }
        if (this.outDir != null) {
            arrayList.add("-d");
            arrayList.add(this.outDir);
        }
        if (this.srcOutDir != null) {
            arrayList.add("-s");
            arrayList.add(this.srcOutDir);
        }
        if (this.processor != null) {
            arrayList.add("-processor");
            arrayList.add(this.processor);
        }
        for (String string : this.processorOpts.keySet()) {
            String string2 = this.processorOpts.get(string);
            if (string2 == null) continue;
            arrayList.add("-A" + string + "=" + string2);
        }
        for (String string : this.otherOpts) {
            arrayList.add(string);
        }
        for (String string : this.testSource) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    protected String[] getTestSource() {
        return this.testSource;
    }

    protected void setTestSource(String[] stringArray) {
        this.testSource = stringArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Collector
    implements DiagnosticListener<JavaFileObject> {
        private Set<String> messages = new HashSet<String>();
        private int errorCount = 0;
        private PrintWriter err;

        public Collector(PrintWriter printWriter) {
            this.err = printWriter;
        }

        public void clear() {
            this.messages.clear();
            this.errorCount = 0;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            if (diagnostic.getKind() == Diagnostic.Kind.NOTE || this.messages.add(diagnostic.toString())) {
                this.err.println(diagnostic.toString());
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    ++this.errorCount;
                }
            }
        }

        public void printSummary() {
            if (this.errorCount > 0) {
                this.err.println("Number of errors: " + this.errorCount);
            }
        }

        public void checkDiagnostics(boolean bl) {
            if (bl) {
                if (this.errorCount > 0) {
                    this.err.println("WARNING! Compilation succeed but an error has been recieved");
                }
            } else if (this.errorCount == 0) {
                this.err.println("WARNING! Compilation failed but no errors have been recieved");
            }
        }
    }
}

