/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.JaxbTckScript;
import java.io.File;

public class PrecompileJaxbTckScript
extends JaxbTckScript {
    protected boolean needCompileStage() {
        return this.isRuntime;
    }

    protected boolean needExecuteStage() {
        return false;
    }

    protected Status compile() {
        File[] fileArray = this.td.getSourceFiles();
        if (fileArray == null || fileArray.length == 0) {
            return error_noSource;
        }
        this.env.put("testClassDir", testSuiteRootDir + File.separator + "classes");
        String string = this.td.getParameter("testSource");
        if (string != null) {
            String[] stringArray = StringArray.split(string);
            String string2 = this.td.getFile().getParent();
            File[] fileArray2 = new File[stringArray.length];
            String string3 = System.getProperty("user.dir") + File.separator;
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(string2, stringArray[i].replace('/', File.separatorChar));
                String string4 = file.getPath();
                if (string4.startsWith(string3)) {
                    string4 = string4.substring(string3.length());
                    fileArray2[i] = new File(string4);
                    continue;
                }
                fileArray2[i] = file;
            }
            fileArray = fileArray2;
            if (fileArray.length == 0) {
                return Status.passed("OK");
            }
        }
        if (this.isSchema || this.isDocument) {
            if (this.onlyJavaSourcesPresented(fileArray)) {
                return this.compileTogether(fileArray);
            }
            return this.compileIndividually(fileArray);
        }
        return this.compileTogether(fileArray);
    }

    protected Status compileIndividually(File[] fileArray) {
        Status status = null;
        for (int i = 0; i < fileArray.length; ++i) {
            status = fileArray[i].getName().endsWith(".xsd") ? super.compile() : (fileArray[i].getName().endsWith(".java") ? super.compileOne(fileArray[i]) : Status.error("Don't know how to compile: " + fileArray[i]));
            if (status.isPassed()) continue;
            return status;
        }
        return status;
    }

    protected Status execute() {
        return Status.passed("OK");
    }

    protected void initTestPackage() {
        if (this.isSchema && this.isPositive || this.isDocument) {
            super.initTestPackage();
        }
    }

    protected void initSchema() {
        if (this.isSchema && this.isPositive || this.isDocument) {
            super.initSchema();
        }
    }

    protected void initOutputDir() throws JaxbTckScript.InitializationException {
        if (this.isSchema && this.isPositive || this.isDocument) {
            super.initOutputDir();
        }
    }

    protected Status generate() {
        return Status.passed("OK");
    }

    private boolean onlyJavaSourcesPresented(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName().endsWith(".java")) continue;
            return false;
        }
        return true;
    }

    public Status run(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        this.initKeywords(testDescription);
        if (!this.isRuntime || this.isRtgen) {
            return Status.passed("OK. Precompilation isn't required.");
        }
        if (this.isJava2WSDL) {
            try {
                this.initTestRun(testDescription, testEnvironment);
            }
            catch (JaxbTckScript.InitializationException initializationException) {
                initializationException.printStackTrace();
                return Status.failed("Precompile failed: " + initializationException.toString() + initializationException.getMessage());
            }
            this.initMacroOutDirValue();
            return this.compile();
        }
        return super.run(stringArray, testDescription, testEnvironment);
    }
}

