/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.Status;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.agent.AgentManager;
import com.sun.jck.lib.ExecJCKTestSameJVMCmd;
import com.sun.jck.lib.JCKScript;
import java.io.IOException;
import java.io.PrintWriter;

class RemoteManager {
    protected Task[] tasks;
    private static Status OK = Status.passed("OK");

    public int getTasksNumber() {
        return this.tasks.length;
    }

    RemoteManager(String string, TestEnvironment testEnvironment, TestResult testResult) throws Fault {
        String[] stringArray = JCKScript.splitIntoLines(string);
        this.tasks = new Task[stringArray.length];
        try {
            Object object;
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                object = stringArray[n];
                String string2 = null;
                String string3 = null;
                String[] stringArray2 = null;
                int n2 = 0;
                int n3 = 0;
                while (n3 < ((String)object).length()) {
                    char c = ((String)object).charAt(n3);
                    if (c == ' ') {
                        ++n3;
                        continue;
                    }
                    if ((n2 == 0 || n2 == 2) && Character.isJavaIdentifierStart(c)) {
                        int n4 = n3++;
                        while (n3 < ((String)object).length() && (Character.isJavaIdentifierPart(c = ((String)object).charAt(n3)) || c == '.')) {
                            ++n3;
                        }
                        String string4 = ((String)object).substring(n4, n3);
                        if (n2 == 0) {
                            string2 = string4;
                        } else {
                            string3 = string4;
                        }
                        ++n2;
                        continue;
                    }
                    if (n2 == 1 && c == ':') {
                        ++n2;
                        ++n3;
                        continue;
                    }
                    if (n2 == 3) {
                        try {
                            stringArray2 = testEnvironment.resolve(((String)object).substring(n3));
                            break;
                        }
                        catch (TestEnvironment.Fault fault) {
                            throw new Fault("error evaluating args for remote entry " + string2);
                        }
                    }
                    throw new Fault("syntax error in remote entry");
                }
                if (string2 == null || string3 == null) {
                    throw new Fault("format error in remote entry");
                }
                TestResult.Section section = testResult.createSection("remote." + string2);
                try {
                    String[] stringArray3 = testEnvironment.lookup("remote." + string2);
                    if (stringArray3 == null || stringArray3.length == 0) {
                        throw new Fault("no value found for remote." + string2 + " in environment");
                    }
                    this.tasks[n] = new Task(stringArray3, string3, stringArray2, section);
                    continue;
                }
                catch (TestEnvironment.Fault fault) {
                    throw new Fault("error evaluating host info for remote entry " + string2);
                }
            }
            for (n = 0; n < this.tasks.length; ++n) {
                object = new Thread(this.tasks[n]);
                ((Thread)object).start();
            }
        }
        catch (Fault fault) {
            this.dispose();
            throw fault;
        }
        catch (RuntimeException runtimeException) {
            this.dispose();
            throw runtimeException;
        }
    }

    synchronized boolean waitUntilDone(int n) throws InterruptedException {
        long l = System.currentTimeMillis();
        long l2 = l + (long)(n * 1000);
        boolean bl = this.isAllTasksDone();
        while (l < l2 && !bl) {
            this.wait(l2 - l);
            l = System.currentTimeMillis();
            bl = this.isAllTasksDone();
        }
        return bl;
    }

    private boolean isAllTasksDone() {
        for (int i = 0; i < this.tasks.length; ++i) {
            if (this.tasks[i] == null || this.tasks[i].isDone()) continue;
            return false;
        }
        return true;
    }

    synchronized void dispose() {
        if (this.tasks == null) {
            return;
        }
        for (int i = 0; i < this.tasks.length; ++i) {
            Task task = this.tasks[i];
            if (task == null) continue;
            task.dispose();
            this.tasks[i] = null;
        }
        this.tasks = null;
    }

    synchronized Status getStatus() {
        if (this.tasks == null) {
            return Status.error("Initialization error");
        }
        Status status = OK;
        for (int i = 0; i < this.tasks.length; ++i) {
            Task task = this.tasks[i];
            if (task == null) continue;
            status = RemoteManager.mergeStatus(status, task.getStatus());
        }
        return status;
    }

    static Status mergeStatus(Status status, Status status2) {
        return status == null ? status2 : (status2 == null ? status : (status.getType() >= status2.getType() ? status : status2));
    }

    class Task
    implements Runnable {
        private final AgentManager.Task amTask;
        private final TestResult.Section trs;
        private final String className;
        private final String[] args;
        private Status status;

        Task(String[] stringArray, String string, String[] stringArray2, TestResult.Section section) throws Fault {
            this.className = string;
            this.args = stringArray2;
            this.trs = section;
            String string2 = null;
            int n = -1;
            String string3 = null;
            for (int i = 0; i < stringArray.length && stringArray[i].startsWith("-"); ++i) {
                if (stringArray[i].equals("-classpath") && i + 1 < stringArray.length) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-host") && i + 1 < stringArray.length) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-port") && i + 1 < stringArray.length) {
                    try {
                        n = Integer.parseInt(stringArray[++i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new Fault("bad port number: " + stringArray[i]);
                    }
                }
                throw new Fault("Unrecognized option: " + stringArray[i]);
            }
            if (string2 == null) {
                throw new Fault("No host specified");
            }
            try {
                AgentManager agentManager = AgentManager.access();
                AgentManager.Task task = this.amTask = n == -1 ? agentManager.connectToPassiveAgent(string2) : agentManager.connectToPassiveAgent(string2, n);
                if (string3 != null) {
                    this.amTask.setClassPath(string3);
                }
            }
            catch (IOException iOException) {
                throw new Fault("Error accessing agent: " + iOException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PrintWriter printWriter = this.trs.getMessageWriter();
            PrintWriter printWriter2 = this.trs.createOutput("log");
            PrintWriter printWriter3 = this.trs.createOutput("ref");
            try {
                printWriter.println("Executing remote component via " + this.amTask.getConnection().getName());
                String string = ExecJCKTestSameJVMCmd.class.getName();
                String[] stringArray = new String[this.args.length + 1];
                stringArray[0] = this.className;
                System.arraycopy(this.args, 0, stringArray, 1, this.args.length);
                this.status = this.amTask.executeCommand(this.trs.getTitle(), string, stringArray, true, printWriter2, printWriter3);
                this.trs.setStatus(this.status);
                RemoteManager remoteManager = RemoteManager.this;
                synchronized (remoteManager) {
                    RemoteManager.this.notifyAll();
                }
            }
            finally {
                printWriter.close();
                printWriter2.close();
                printWriter3.close();
            }
        }

        Status getStatus() {
            return this.status;
        }

        boolean isDone() {
            return this.status != null;
        }

        void dispose() {
            if (this.status == null) {
                this.status = Status.error("incomplete");
                this.trs.setStatus(this.status);
            }
        }
    }

    public static class Fault
    extends Exception {
        private String[] msgs;

        public Fault(String string) {
            super(string);
            this.msgs = new String[1];
            this.msgs[0] = string;
        }

        public Fault(String[] stringArray) {
            super(stringArray[0]);
            this.msgs = stringArray;
        }

        public String[] getMessages() {
            return this.msgs;
        }
    }
}

