/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.jck4jdk;

import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.WrapWriter;
import com.sun.jck.lib.jck4jdk.Main;
import com.sun.jck.lib.jck4jdk.Option;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class Help {
    private Option[] options;
    private List<String> commandLineHelpQuery;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public Help(Option[] options) {
        this.options = options;
    }

    void setCommandLineHelpQuery(String query) {
        if (this.commandLineHelpQuery == null) {
            this.commandLineHelpQuery = new ArrayList<String>();
        }
        if (query != null) {
            this.commandLineHelpQuery.addAll(Arrays.asList(query.trim().split("\\s+")));
        }
    }

    void showCommandLineHelp(PrintWriter out) {
        Integer descIndent;
        HelpTree commandHelpTree = new HelpTree();
        Integer nodeIndent = Integer.getInteger("javatest.help.nodeIndent");
        if (nodeIndent != null) {
            commandHelpTree.setNodeIndent(nodeIndent);
        }
        if ((descIndent = Integer.getInteger("javatest.help.descIndent")) != null) {
            commandHelpTree.setDescriptionIndent(descIndent);
        }
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        for (Option o : this.options) {
            if (o.group == null) continue;
            groups.add(o.group);
        }
        LinkedHashMap map = new LinkedHashMap();
        for (String g : groups) {
            map.put(g, new TreeMap(new CaseInsensitiveStringComparator()));
        }
        for (Option o : this.options) {
            if (o.group == null || o.names.length <= 0) continue;
            ((SortedMap)map.get(o.group)).put(o.names[0], o);
        }
        for (String g : groups) {
            SortedMap optionsForGroup = (SortedMap)map.get(g);
            if (optionsForGroup.isEmpty()) continue;
            ArrayList<HelpTree.Node> nodesForGroup = new ArrayList<HelpTree.Node>();
            for (Option o : optionsForGroup.values()) {
                nodesForGroup.add(this.createOptionHelpNode(o));
            }
            HelpTree.Node groupNode = new HelpTree.Node(i18n, "help." + g.toString().toLowerCase(), nodesForGroup.toArray(new HelpTree.Node[nodesForGroup.size()]));
            commandHelpTree.addNode(groupNode);
        }
        try {
            WrapWriter ww = new WrapWriter(out);
            if (this.commandLineHelpQuery == null || this.commandLineHelpQuery.size() == 0) {
                ww.write(i18n.getString("help.cmd.proto"));
                ww.write("\n\n");
                ww.write(i18n.getString("help.cmd.introHead"));
                ww.write('\n');
                commandHelpTree.writeSummary(ww);
            } else if (this.commandLineHelpQuery.contains("all")) {
                ww.write(i18n.getString("help.cmd.proto"));
                ww.write("\n\n");
                ww.write(i18n.getString("help.cmd.fullHead"));
                ww.write('\n');
                commandHelpTree.write(ww);
            } else {
                String[] query = this.commandLineHelpQuery.toArray(new String[this.commandLineHelpQuery.size()]);
                HelpTree.Selection s = commandHelpTree.find(query);
                if (s != null) {
                    commandHelpTree.write((Writer)ww, s);
                } else {
                    ww.write(i18n.getString("help.cmd.noEntriesFound"));
                    ww.write("\n\n");
                    ww.write(i18n.getString("help.cmd.summaryHead"));
                    ww.write('\n');
                    commandHelpTree.writeSummary(ww);
                }
            }
            ww.write('\n');
            ww.write(i18n.getString("help.cmd.tail"));
            ww.write("\n\n");
            ww.write(i18n.getString("help.copyright.txt"));
            ww.write("\n\n");
            ww.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private HelpTree.Node createOptionHelpNode(Option o) {
        String prefix = "help." + o.group.toString().toLowerCase() + "." + o.names[0];
        String arg = o.argType == Option.ArgType.NONE ? null : i18n.getString(prefix + ".arg");
        StringBuilder sb = new StringBuilder();
        block7: for (String n : o.names) {
            if (sb.length() > 0) {
                sb.append("  |  ");
            }
            sb.append("-");
            sb.append(n);
            switch (o.argType) {
                case NONE: {
                    continue block7;
                }
                case OLD: 
                case STD: 
                case FILE: {
                    sb.append(":").append(arg);
                    continue block7;
                }
                case REST: {
                    sb.append(" ").append(arg);
                    continue block7;
                }
                case WILDCARD: {
                    sb.append(arg);
                    continue block7;
                }
                case OPT: {
                    sb.append("  |  -").append(n).append(":").append(arg);
                    continue block7;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        String name = sb.toString();
        String desc = i18n.getString(prefix + ".desc");
        String[] values = o.getChoices();
        if (values == null || values.length == 0) {
            return new HelpTree.Node(name, desc);
        }
        HelpTree.Node[] children = new HelpTree.Node[values.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = new HelpTree.Node(values[i], i18n.getString(prefix + "." + values[i] + ".desc"));
        }
        return new HelpTree.Node(name, desc, children);
    }

    private static class CaseInsensitiveStringComparator
    implements Comparator<String> {
        private CaseInsensitiveStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null || s2 == null) {
                return s1 == null ? -1 : 1;
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

