/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.jck4jdk;

import com.sun.jck.lib.jck4jdk.BadArgs;
import java.util.Arrays;

public abstract class Option {
    public final ArgType argType;
    public final String group;
    public final String lockName;
    public final String[] names;

    public Option(ArgType a, String g, String ln, String ... names) {
        this.argType = a;
        this.group = g;
        this.lockName = ln != null && ln.length() == 0 && names.length > 0 ? names[0] : ln;
        this.names = names;
    }

    public String[] getChoices() {
        return null;
    }

    public boolean matches(String name) {
        switch (this.argType) {
            case FILE: {
                return false;
            }
            case WILDCARD: {
                for (String n : this.names) {
                    if (!name.startsWith(n)) continue;
                    return true;
                }
                break;
            }
            default: {
                for (String n : this.names) {
                    if (!name.equals(n)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getValue(String arg) {
        switch (this.argType) {
            case WILDCARD: {
                for (String n : this.names) {
                    if (!arg.startsWith(n)) continue;
                    return arg.substring(n.length());
                }
                break;
            }
        }
        return null;
    }

    public String toString() {
        return "Option[" + (Object)((Object)this.argType) + "," + this.group + "," + this.lockName + "," + Arrays.asList(this.names) + "]";
    }

    public abstract void process(String var1, String var2) throws BadArgs;

    public static enum ArgType {
        NONE,
        STD,
        OLD,
        OPT,
        WILDCARD,
        REST,
        FILE;

    }
}

