/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.multijvm.group.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgMap<E extends Enum>
extends LinkedHashMap<E, List<String>> {
    private final E[] keys;

    public ArgMap(E ... EArray) {
        this.keys = EArray;
    }

    public ArgMap(List<String> list, E ... EArray) {
        this.keys = EArray;
        this.loadFromList(list);
    }

    public ArgMap(String[] stringArray, E ... EArray) {
        this.keys = EArray;
        this.loadFromList(Arrays.asList(stringArray));
    }

    protected Pattern getKeyPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            stringBuffer.append(((Enum)this.keys[n++]).toString());
            if (n == this.keys.length) break;
            stringBuffer.append('|');
        }
        return Pattern.compile("^-M(" + stringBuffer.toString() + ")_$");
    }

    public void loadFromList(List<String> list) {
        Pattern pattern = this.getKeyPattern();
        Object k = null;
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            if (i != 0) {
                this.put(k, list.subList(n, i));
            }
            k = Enum.valueOf(((Enum)this.keys[0]).getDeclaringClass(), matcher.group(1));
            n = i + 1;
        }
        this.put(k, list.subList(n, list.size()));
    }

    @Override
    public List<String> get(E e) {
        List list = (List)super.get(e);
        return list == null ? Collections.EMPTY_LIST : list;
    }

    public List<String> getUnmapped() {
        return this.get((E)null);
    }
}

