/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.services;

import com.sun.javatest.services.Message;
import com.sun.javatest.services.Service;
import com.sun.javatest.services.ServiceExecutor;
import com.sun.jck.services.AbstractService;
import com.sun.jck.services.ActiveAgentService;
import com.sun.jck.services.DummyExecutor;
import com.sun.jck.services.MutualService;
import com.sun.jck.services.PassiveAgentService;
import java.util.Properties;
import java.util.logging.Level;

public class AgentService
extends AbstractService {
    private MutualService service = new NoService();

    public ServiceExecutor getDefaultServiceExecutor() {
        return this.getService().getDefaultServiceExecutor();
    }

    public Message prepareMessage(Message.MessageType messageType) throws Service.MalformedParamsException {
        return this.getService().prepareMessage(messageType);
    }

    public boolean start() throws Service.NotConnectedException, Service.ServiceError {
        return this.getService().start();
    }

    public boolean stop() throws Service.NotConnectedException, Service.ServiceError {
        return this.getService().stop();
    }

    public boolean isAlive() throws Service.NotConnectedException, Service.ServiceError {
        return this.getService().isAlive();
    }

    public synchronized Service getService() {
        if (this.props == null) {
            return this.service;
        }
        Properties properties = this.props.getExternalProperties();
        if (properties.isEmpty()) {
            return this.service;
        }
        String string = properties.getProperty("agent.type");
        Class clazz = this.getServiceClass(string);
        if (clazz.isInstance(this.service)) {
            return this.service;
        }
        try {
            this.service = (MutualService)clazz.newInstance();
            this.service.setParent(this);
        }
        catch (InstantiationException instantiationException) {
            this.getLog().log(Level.SEVERE, "Can't instantiate " + clazz, instantiationException);
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.getLog().log(Level.SEVERE, "Can't instantiate " + clazz, illegalAccessException);
            throw new RuntimeException(illegalAccessException);
        }
        return this.service;
    }

    private Class getServiceClass(String string) {
        if ("active".equals(string)) {
            return ActiveAgentService.class;
        }
        if ("passive".equals(string)) {
            return PassiveAgentService.class;
        }
        return NoService.class;
    }

    public boolean enabled() {
        return !(this.getService() instanceof NoService);
    }

    public static class NoService
    extends MutualService {
        public ServiceExecutor getDefaultServiceExecutor() {
            return new DummyExecutor();
        }

        public boolean start() throws Service.NotConnectedException, Service.ServiceError {
            return false;
        }

        public boolean stop() throws Service.NotConnectedException, Service.ServiceError {
            return false;
        }

        public boolean isAlive() throws Service.NotConnectedException, Service.ServiceError {
            return false;
        }

        public Message prepareMessage(Message.MessageType messageType) throws Service.MalformedParamsException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

