/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.services;

import com.sun.javatest.services.Message;
import com.sun.jck.services.LoggingExecutor;
import com.sun.jck.services.PortBoundParams;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;

public class PortBoundExecutor
extends LoggingExecutor {
    private String host;
    private int port;
    private float timeoutFactor;

    public Message startService(Message message) {
        Message message2 = super.startService(message);
        if (message2.getType() != Message.MessageType.STARTED) {
            return message2;
        }
        PortBoundParams portBoundParams = (PortBoundParams)message.getContent();
        this.port = Integer.parseInt(portBoundParams.getPort());
        this.host = portBoundParams.getHost();
        this.timeoutFactor = portBoundParams.getTimeoutFactor();
        boolean bl = this.waitForStarted(this.host, this.port);
        if (!bl) {
            String string = (String)((Object)message2.getContent());
            if (string == null) {
                string = "";
            }
            message2 = new Message(Message.MessageType.ERROR, (Serializable)((Object)("Service startup failed by timeout.\n" + string)));
            this.stopService(new Message(Message.MessageType.STOP, null));
        }
        return this.addProcessLog(message2);
    }

    public Message stopService(Message message) {
        Message message2 = super.stopService(message);
        if (message2.getType() == Message.MessageType.ERROR && !PortBoundExecutor.isBound(this.host, this.port)) {
            message2 = new Message(Message.MessageType.STOPPED, message2.getContent());
        }
        return message2;
    }

    public boolean waitForStarted(String string, int n) {
        boolean bl = false;
        for (int i = 0; i < 20; ++i) {
            try {
                if (!this.isProcessAlive() || (bl = PortBoundExecutor.isBound(string, n))) break;
                int n2 = Math.round(this.timeoutFactor * 500.0f);
                int n3 = Integer.getInteger("jck.serviceTimeFactorMultiplier", 1);
                Thread.sleep(n2 * n3);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return bl;
    }

    public static boolean isBound(String string, int n) {
        try {
            Socket socket = new Socket(string, n);
            socket.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

