/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.util.StringArray;
import java.io.File;

public class RmicTestScript
extends Script {
    private static final Status fail_noRmicClasses = Status.failed("no rmicClasses specified");

    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        boolean expectFail = false;
        boolean compile = false;
        boolean compileIndividually = false;
        boolean execute = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-compile") || arg.equals("-compileTogether")) {
                compile = true;
                continue;
            }
            if (arg.equals("-compileIndividually")) {
                compileIndividually = true;
                compile = true;
                continue;
            }
            if (arg.equals("-execute")) {
                execute = true;
                continue;
            }
            if (arg.equals("-expectFail")) {
                expectFail = true;
                continue;
            }
            return Status.failed("bad arg for script: `" + arg + "'");
        }
        if (compile) {
            File[] srcs = td.getSourceFiles();
            Status compileStatus = compileIndividually ? this.compileIndividually(srcs) : this.compileTogether(srcs);
            if (compileStatus.getType() == 0) {
                String rmiClasses = td.getParameter("rmicClasses");
                if (rmiClasses == null) {
                    rmiClasses = td.getParameter("rmicClass");
                }
                if (rmiClasses == null) {
                    return fail_noRmicClasses;
                }
                compileStatus = this.rmicompile(StringArray.split(rmiClasses));
            }
            if (!execute) {
                if (expectFail) {
                    if (compileStatus.getType() == 1) {
                        return Script.pass_compFailExp.augment(compileStatus);
                    }
                    return Script.fail_compSuccUnexp.augment(compileStatus);
                }
                return compileStatus;
            }
            if (compileStatus.getType() == 1) {
                return Script.fail_compFailUnexp.augment(compileStatus);
            }
        }
        if (execute) {
            String executeClass = td.getParameter("executeClass");
            if (executeClass == null) {
                return Script.error_noExecuteClass;
            }
            Status executeStatus = this.execute(executeClass, td.getParameter("executeArgs"));
            if (expectFail) {
                if (executeStatus.getType() == 1) {
                    return Script.pass_execFailExp.augment(executeStatus);
                }
                return Script.fail_execSuccUnexp.augment(executeStatus);
            }
            return executeStatus;
        }
        return Script.error_noActionSpecified;
    }

    private Status rmicompile(String[] classes) {
        try {
            String[] classDir = this.env.lookup("testClassDir");
            if (classDir == null || classDir.length != 1) {
                return Status.failed("classDir not a file URL");
            }
            File f = new File(classDir[0]);
            if (!f.exists()) {
                f.mkdirs();
            }
        }
        catch (TestEnvironment.Fault e) {
            return Status.failed("problem finding testClassDir");
        }
        this.env.put("testRmicClasses", classes);
        this.env.put("testRmicClass", classes);
        return this.invokeCommand("rmic");
    }
}

