/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.FOSFactory;
import javasoft.sqe.javatest.lib.MultiTest;
import javasoft.sqe.javatest.lib.WrapStatus;

public abstract class SerializeTest
extends MultiTest {
    protected URL serialFileURL;
    protected Object[] expectedValues;
    protected boolean doEqualsTest = true;
    protected boolean doStringTest = true;
    protected boolean setupSerFile = false;
    private String testURL = null;
    private String fileName = null;

    protected SerializeTest() {
    }

    protected void init() throws MultiTest.SetupException {
        if (this.fileName == null) {
            throw new MultiTest.SetupException("No file name defined");
        }
        if (this.testURL == null) {
            throw new MultiTest.SetupException("No Test URL defined");
        }
        try {
            this.serialFileURL = new URL(this.testURL);
            this.serialFileURL = new URL(this.serialFileURL, this.fileName);
        }
        catch (IOException e) {
            throw new MultiTest.SetupException("Could not create test URL: " + e.toString());
        }
        Status tempStatus = this.createValues();
        if (tempStatus.getType() != 0) {
            throw new MultiTest.SetupException(tempStatus.getReason());
        }
        if (this.setupSerFile) {
            System.out.println("Serialized data file update returned the following status: " + this.setup().getStatus());
            System.exit(0);
        }
    }

    protected int decodeArg(String[] argv, int index) throws MultiTest.SetupException {
        if (argv[index].equals("-TestURL")) {
            if (index + 1 < argv.length && !argv[index + 1].startsWith("-")) {
                this.testURL = argv[index + 1];
                return 2;
            }
            this.testURL = "";
            return 1;
        }
        if (argv[index].equals("-FileName")) {
            if (index + 1 < argv.length && !argv[index + 1].startsWith("-")) {
                this.fileName = argv[index + 1];
                return 2;
            }
            this.fileName = "";
            return 1;
        }
        if (argv[index].equals("-setupSerFile")) {
            this.setupSerFile = true;
            return 1;
        }
        return super.decodeArg(argv, index);
    }

    protected void getAllTestCases() throws MultiTest.SetupException {
        Method[] tests = new Method[]{this.getTestCase("testRead"), this.getTestCase("testWrite")};
        this.testMethods = tests;
    }

    protected abstract Status createValues();

    public WrapStatus setup() {
        Status s = null;
        try {
            FOSFactory fosfact = (FOSFactory)Class.forName("javasoft.sqe.javatest.lib.FOSFactoryImpl").newInstance();
            OutputStream oStream = fosfact.getFileOutputStream(this.serialFileURL.getFile());
            ObjectOutputStream objOStream = new ObjectOutputStream(oStream);
            s = this.write(objOStream, this.expectedValues);
            oStream.close();
        }
        catch (ExceptionInInitializerError e) {
            e.printStackTrace(this.log);
            s = Status.failed("Unexpected error : " + e);
        }
        catch (LinkageError e) {
            e.printStackTrace(this.log);
            s = Status.failed("Unexpected error : " + e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(this.log);
            s = Status.failed("Unexpected error : " + e);
        }
        catch (InstantiationException e) {
            e.printStackTrace(this.log);
            s = Status.failed("Unexpected error : " + e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(this.log);
            s = Status.failed("Unexpected error : " + e);
        }
        catch (IOException e) {
            s = Status.failed("Unexpected: " + e);
        }
        return new WrapStatus(s);
    }

    public Status testRead() throws ClassNotFoundException, IOException, OptionalDataException {
        ObjectInputStream iStream = new ObjectInputStream(this.serialFileURL.openStream());
        Status s = this.read(iStream, this.expectedValues);
        iStream.close();
        return s;
    }

    public Status testWrite() throws ClassNotFoundException, IOException, OptionalDataException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oStream = new ObjectOutputStream(baos);
        this.write(oStream, this.expectedValues);
        byte[] bytes = baos.toByteArray();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream iStream = new ObjectInputStream(bais);
        Status s = this.read(iStream, this.expectedValues);
        iStream.close();
        return s;
    }

    protected Status validate(Object expectedResult, Object result, String stringResult) {
        String expectedString = expectedResult.toString();
        if (this.doEqualsTest && !expectedResult.equals(result)) {
            return Status.failed("Equals test, expected: " + expectedString + ", received: " + result.toString());
        }
        if (this.doStringTest && !expectedString.equals(stringResult)) {
            return Status.failed("String equals test, expected: " + expectedString + ", received: " + stringResult);
        }
        return Status.passed("");
    }

    private Status read(ObjectInputStream iStream, Object[] expectedResult) throws ClassNotFoundException, IOException, OptionalDataException {
        int serializedObjects = iStream.readInt();
        if (serializedObjects != expectedResult.length) {
            return Status.failed("Expected: " + expectedResult.length + " serialized objects.  Result: " + serializedObjects);
        }
        for (int i = 0; i < serializedObjects; ++i) {
            String testValString;
            Object testVal = iStream.readObject();
            Status validateStatus = this.validate(expectedResult[i], testVal, testValString = (String)iStream.readObject());
            if (validateStatus.getType() == 0) continue;
            return validateStatus;
        }
        return Status.passed("OKAY");
    }

    private Status write(ObjectOutputStream oStream, Object[] desiredVal) throws IOException {
        oStream.writeInt(desiredVal.length);
        for (int i = 0; i < desiredVal.length; ++i) {
            oStream.writeObject(desiredVal[i]);
            oStream.writeObject(desiredVal[i].toString());
        }
        oStream.flush();
        return Status.passed("OKAY");
    }
}

