/*
 * Copyright (c) 1996-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.ActivationDataFlavor;

import java.io.*;
import java.awt.datatransfer.*;
import javax.activation.*;
import com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 

/**
 * We first create an object of type ActivationDataFlavor, then
 * call getHumanPresentableName() api on that object, if it returns
 * the same string value as that passed to ActivationDataFlavor 
 * constructor then this testcase passes otherwise it fails.
 */

public class getHumanPresentableName_Test extends MultiTest {

    // main
    public static void main(String[] args)
    {
	Test t = new getHumanPresentableName_Test(); 
	Status s = t.run(args, new PrintWriter(System.err, true), new PrintWriter(System.out, true)); 
	s.exit(); 
    }

    // Tests for equals:
    public Status testGetHumanPresentableName()
    {
	String humanName = "TextPlain DataFlavor";

	ActivationDataFlavor adf = new ActivationDataFlavor("text/plain", humanName);

	if(adf.getHumanPresentableName().equals(humanName))	// API TEST
	    return Status.passed("getHumanPresentableName() test succeeded");
	else
	    return Status.failed("getHumanPresentableName() test failed: "
					+ adf.getHumanPresentableName() + " != " + humanName);
    }
}
