/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.DataHandler;

import  java.io.*;
import  javax.activation.*;
import  com.sun.javatest.*;
import  javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/**
 * Create a DataHandler object then use it to call getContent() api,
 * if this method returns non-null Object then this testcase passes.
 */

public class getContent_Test implements Test
{
	public static void main(String argv[])
	{
		getContent_Test lTest = new getContent_Test();
		Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
		lStatus.exit();
	}

	public Status run(String argv[], PrintWriter outLog, PrintWriter outConsole)
	{
		try {
			// create a DataHandler object
			DataHandler dhl = new DataHandler(new TestCommandObject(), "foo/goo");

                	if( dhl == null )
                    		return Status.failed("DataHandler() failed to return DataHandler object!");

			// get content
			Object content = dhl.getContent();	// API TEST

			if( content == null )
		    		return Status.failed("getContent failed to return non-null Object!");
		} catch (Exception e) {
			return Status.failed("Exception caught!");
		}
		return Status.passed("getContent() test succeeded");
	}
}
