/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.FileDataSource;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 
import	javasoft.sqe.tests.api.javax.activation.TestClasses.TestFileTypeMap;

/**
 * Create a FileDataSource instance and then use it to call getFile() api,
 * if this method returns a non-null File object, then this testcase 
 * passes, otherwise it fails. <p>
 */

public class getFile_Test extends MultiTest
{
private static final String	kFileName = "FDSTestFile.txt";

public static void main(String argv[])
{
	getFile_Test lTest = new getFile_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status getFileTest()
{
	FileDataSource fdsFromFile = new FileDataSource(new File(kFileName));
	FileDataSource fdsFromFileName = new FileDataSource(kFileName);
	File fob1 = fdsFromFile.getFile();		// API TEST
	File fob2 = fdsFromFileName.getFile();		// API TEST

	if( fob1 == null )
	    return Status.failed("getFile() test failed");
	if( fob2 == null )
	    return Status.failed("getFile() test failed");

	return Status.passed("getFile() test passed");
}

}
