/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeType;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 

/**
 * Create a MimeType instance, use it to call getSubType() method, if
 * it returns subtype string of this object then this test passes. <p>
 */

public class getSubType_Test extends MultiTest
{

public static void main(String argv[])
{
	getSubType_Test lTest = new getSubType_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status	getSubTypeTest1()
{	
	try {
		MimeType objmt =  new MimeType();

		if( objmt == null )
		    return Status.failed("Failed: to create MimeType object using constructor");

                String subtype =  objmt.getSubType();       // API TEST

                if( subtype == null )
                    return Status.failed("Failed: getSubType() returned null string!");
 
	} catch(Exception ex) {
		return Status.failed("getSubType() threw " + ex.toString());
	}

	return Status.passed("getSubType(void) test succeeded");
}

public Status   getSubTypeTest2()
{
        try {
                MimeType objmt =  new MimeType("text/plain");

                if( objmt == null )
                    return Status.failed("Failed: to create MimeType object using constructor");

                String subtype =  objmt.getSubType();       // API TEST

                if( subtype == null )
                    return Status.failed("Failed: getSubType() returned null string!");

        } catch(Exception ex) {
                return Status.failed("getSubType() threw " + ex.toString());
        }

        return Status.passed("getSubType(void) test succeeded");
}

}
