/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeTypeParameterList;

import	java.beans.*;
import	java.io.*;
import  java.util.Enumeration;
import	javax.activation.*;
import	java.net.*;
import	com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 
import	java.awt.datatransfer.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/**
 * Create an instance of MimeTypeParameterList, then use it to call getNames() method,
 * if it returns an enumeration of all the names in this list, then this testcase
 * passes, otherwise it fails. <p>
 */

public class getNames_Test extends MultiTest
{
public static void main(String argv[])
{
	getNames_Test lTest = new getNames_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status getNamesTest()
{
        try {
              MimeTypeParameterList mtpl =  new MimeTypeParameterList(";charset=us-ascii;isoset=iso-9000;foo=abc");

              if( mtpl == null )
                  return Status.failed("Failed: to create MimeTypeParameterList object using constructor");
	      Enumeration names = mtpl.getNames();	// API TEST

	      while ( names.hasMoreElements() ) {
                      String name = (String)names.nextElement();
                      //out.println(name);
	      }

        } catch(Exception ex) {
                return Status.failed("getNames() threw " + ex.toString());
        }

	return Status.passed("getNames() test succeeded");
}

}
