/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeTypeParameterList;

import	java.beans.*;
import	java.io.*;
import	javax.activation.*;
import	java.net.*;
import	com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 
import	java.awt.datatransfer.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/**
 * Create an instance of MimeTypeParameterList, then use it to call get() method,
 * with a string argument, if it returns a value(non-null/null) associated with
 * passed in argument, then this test passes, otherwise it fails. <p>
 */

public class get_Test extends MultiTest
{
public static void main(String argv[])
{
	get_Test lTest = new get_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status getTest()
{
        try {
              MimeTypeParameterList mtpl =  new MimeTypeParameterList(";charset=us-ascii;isoset=iso-9000;foo=abc");

              if( mtpl == null )
                  return Status.failed("Failed: to create MimeTypeParameterList object using constructor");
	      String value = mtpl.get("charset");	// API TEST

	      if( !value.equals("us-ascii") )
		  return Status.failed("get(String) failed to get expected "+value+" value");

              value = mtpl.get("foo");       // API TEST

              if( !value.equals("abc") )
                  return Status.failed("get(String) failed to get expected "+value+" value");

              value = mtpl.get("xyz");       // API TEST

              if( value != null )
                  return Status.failed("get(xyz) failed to get expected "+value+" value");

        } catch(Exception ex) {
                return Status.failed("get(string) threw " + ex.toString());
        }

	return Status.passed("get(String) test succeeded");
}

}
