/*
 * Copyright (c) 2002-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.MimetypesFileTypeMap;

import java.util.*;
import java.io.*;
import javax.activation.*;
import com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 

/**
 * This class tests that resource files are loaded as expected. <p>
 * api2test: public String[] getNativeCommands(String) <p>
 *
 * how2test: Create a MimetypesFileTypeMap
 */

public class loadFromLib_Test extends MultiTest {

    private static final String mimeType = "application/x-test";
    private static final String ext = "xyz";
    private static final String entry = mimeType + " " + ext;

    public static void main( String argv[] )
    {
        loadFromLib_Test test = new loadFromLib_Test();
        Status s = test.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	s.exit();
    }

    /**
     * We don't expect to be able to write into java.home so
     * create a fake java.home and point the System property
     * to it.
     */
    public void init() throws SetupException
    {
	try {
	    File home = File.createTempFile("javahome", "conf");
	    home.delete();	// delete the temp file
	    home.mkdir();	// reuse the name for a directory
	    home.deleteOnExit();
	    System.setProperty("java.home", home.getPath());
	    File lib = new File(home, "lib");
	    lib.mkdir();
	    lib.deleteOnExit();
	    File mimetypes = new File(lib, "mime.types");
	    mimetypes.deleteOnExit();
	    PrintWriter pw = new PrintWriter(mimetypes);
	    pw.println(entry);
	    pw.close();
	} catch (IOException ioex) {
	    throw new SetupException(ioex.toString());
	}
    }

    public Status loadFromLibTest()
    {
        try {
          // BEGIN UNIT TEST 1:

	     // Get MimetypesFileTypeMap object
	     MimetypesFileTypeMap mt = new MimetypesFileTypeMap();

	     String ct = mt.getContentType("test." + ext);

             if (ct != null && ct.equals(mimeType)) {
		return Status.passed("loadFromLib passed");
             } else {
		return Status.failed("loadFromLib FAILED");
             }
          // END UNIT TEST 1:

        } catch ( Exception e ) {
	    return Status.failed("loadFromLib FAILED with exception " + e);
        }
    }
}
