/*
* Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

package com.sun.ts.tests.jaspic.tssv.util;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

/**
 *
 * @author Raja Perumal
 */
public class AuthDataCallbackHandler implements CallbackHandler {
    
    private String user;
    private String password;
    
    // Default constructor gets the user and password from the environment
    // using system property j2eelogin.name and j2eelogin.password
    public AuthDataCallbackHandler() {
        user = System.getProperty("j2eelogin.name");
        password = System.getProperty("j2eelogin.password");
    }
    
    public AuthDataCallbackHandler(String usr, String pwd){
        user = usr;
        password = pwd;
        
    }
    
    public void handle(Callback[] callbacks) {
        for (Callback cb : callbacks) {
            if (cb instanceof NameCallback) {
                NameCallback nc = (NameCallback)cb;
                nc.setName(user);
            } else if (cb instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)cb;
                if(password!=null){
                  pc.setPassword(password.toCharArray());
                }else{
                    pc.setPassword(null);
                }
            }
        }
    }
    
}
