/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Provider;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getClassName()</strong> API.
 * It does this by passing various valid input values and then checking the type
 * of the object returned.  <p>
 *		Returns name of the class that implements the protocol. <p>
 * api2test: public String getClassName()  <p>
 *
 * how2test: Call this API, check that it returns the expected class name.
 *	     If it does then this testcase passes, otherwise it fails.
 */

public class getClassName_Test extends MailTest {

    public static void main( String argv[] )
    {
        getClassName_Test test = new getClassName_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

	out.println("\nTesting class Provider: getClassName()\n");

        try {
	   // Get Session object
              Session session = Session.getInstance(properties, null);
	      Provider prov = session.getProvider(protocol);

              if( prov == null ) {
                  return Status.failed("Failed to get Provider object!");
              }
           // BEGIN UNIT TEST 1:
              out.println("UNIT TEST 1: getClassName()");

	      String className = prov.getClassName();	// API TEST

              if( className != null ) {
		  out.println("The class that implements "+ protocol +" is "+ className);
                  out.println("UNIT TEST 1:  passed\n");
              } else {
                      out.println("UNIT TEST 2:  FAILED\n");
                      errors++;
              }
           // END UNIT TEST 1:

	      checkStatus();

        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
