/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Session;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getProvider()</strong> API.
 * It does this by passing various valid input values and then checking the type
 * of the object returned.  <p>
 *		Returns the default Provider for the protocol specified. <p>
 * api2test: public Provider getProvider(String)  <p>
 *
 * how2test: Test getting a closed Folder object for the given URL. Pass a valid URL <p>
 *	     object, if this API returns a valid Folder object then the test passes.
 */

public class getProvider_Test extends MailTest {

    public static void main( String argv[] )
    {
        getProvider_Test test = new getProvider_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

	out.println("\nTesting class Session: getProvider(String)\n");

        try {
          // BEGIN UNIT TEST 1:
	     // Get Session object
             Session session = Session.getInstance(properties, null);
             out.println("UNIT TEST 1: getProvider("+ protocol +")");

             Provider provide = session.getProvider(protocol); // API TEST

             if( provide != null )
                 out.println("UNIT TEST 1:  passed\n");
             else {
		    out.println("UNIT TEST 1:  FAILED\n");
                    errors++;
             }
          // END UNIT TEST 1:
	     checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
