/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.URLName;

import java.util.*;
import java.io.*;
import javax.mail.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getPort()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Returns the port number of this URLName. <p>
 * api2test: public int getPort()  <p>
 *
 * how2test: Call this API, check the value/type of returned object.
 *	     If its an integer then this testcase passes.
 */

public class getPort_Test extends MailTest {

    public static void main( String argv[] )
    {
        getPort_Test test = new getPort_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class URLName: getPort()\n");

        try {
	   // Create a URLName object
              URLName urlname = new URLName(protocol, host, 0, mailbox, user, password);

              if( urlname == null )
                  return Status.failed("Failed to create a URLName object!");

           // BEGIN UNIT TEST 1:
              out.println("UNIT TEST 1:  getPort()");
              int portid = urlname.getPort(); 	// API TEST

              if( portid > -1 ) {
		  out.println("Port number is "+ portid);
                  out.println("UNIT TEST 1: passed");
	      } else {
		      out.println("UNIT TEST 1: FAILED.\n");
		      errors++;
	      }
           // END UNIT TEST 1:

	      checkStatus();
        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
