/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.ContentType;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getParameterList()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 * 
 *		Return a ParameterList object that holds all the available parameters. <p>
 * api2test: public ParameterList getParameterList()  <p>
 *
 * how2test: Call API, verify that it return a ParameterList object.
 *	     If so then testcase passes, otherwise it fails.
 */

public class getParameterList_Test extends MailTest {

    public static void main( String argv[] )
    {
        getParameterList_Test test = new getParameterList_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	 super.run(argv, log, out);
	// parse command-line options
	parseArgs(argv);

        out.println("\nTesting class ContentType: getParameterList()\n");

        try {
	   // Create ContentType object
              ContentType ct = new ContentType(pattern);

              if( ct == null )
		  return Status.failed("Failed to create ContentType object!");

           // BEGIN UNIT TEST 1:
              out.println("UNIT TEST 1: getParameterList()");
              ParameterList plist = ct.getParameterList();    // API TEST

              if( plist != null )
                  out.println("UNIT TEST 1: passed.\n");
              else {
                    out.println("UNIT TEST 1: FAILED.\n");
                    errors++;
              }
           // END UNIT TEST 1:

              checkStatus();
        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
