/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.MimeMessage;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>setSubject()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		Set the 'Subject' header field. <p>
 * api2test: public void setSubject(String)  <p>
 *		Set the 'Subject' and 'character set' header fields. <p>
 * api2test: public void setSubject(String, String)  <p>
 *
 * how2test: Call APIs, then check if the string value returned by getSubject()
 *	     is the same as that set by setSubject() method. If it is then this
 *	     testcase passes, otherwise it fails.
 */

public class setSubject_Test extends MailTest {

    public static void main( String argv[] )
    {
        setSubject_Test test = new setSubject_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class MimeMessage: setSubject(String, String)\n");

        try {
          // Create a MimeMessage object
             Session session = Session.getInstance(properties, null);
             MimeMessage msg = new MimeMessage(session);

             if( msg == null ) {
                 log.println("WARNING: FAILED TO CREATE MESSAGE OBJECT");
                 return Status.failed("Failed to create Message object");
             }
          // BEGIN UNIT TEST:
             out.println("UNIT TEST 1: setSubject(String, String)");

	     String substr = "hot ice cream";

	     msg.setSubject(substr);			// API TEST
	     msg.setSubject(substr, "us-ascii" );	// API TEST

	     if ( substr.equals( msg.getSubject() ))
		  out.println("UNIT TEST 1: passed\n");
	     else {
		   out.println("UNIT TEST 1: FAILED\n");
		   errors++;
	     }
	  // END UNIT TEST:

             checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
