/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.io.PrintWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class DomText
extends DomCharacterData
implements Text {
    private static final long serialVersionUID = 6589779086230288951L;
    public static final String NODE_NAME = "#text";

    public DomText(Page page, String data) {
        super(page, data);
    }

    public Text splitText(int offset) {
        return this.splitDomText(offset);
    }

    protected DomText createSplitTextNode(int offset) {
        return new DomText(this.getPage(), this.getData().substring(offset));
    }

    public DomText splitDomText(int offset) {
        if (offset < 0 || offset > this.getLength()) {
            throw new IllegalArgumentException("offset: " + offset + " data.length: " + this.getLength());
        }
        DomText newText = this.createSplitTextNode(offset);
        this.setData(this.getData().substring(0, offset));
        if (this.getParentNode() != null) {
            newText.setParentNode(this.getParentNode());
            newText.setPreviousSibling(this);
            newText.setNextSibling(this.getNextSibling());
            this.setNextSibling(newText);
        }
        return newText;
    }

    public boolean isElementContentWhitespace() {
        throw new UnsupportedOperationException("DomText.isElementContentWhitespace is not yet implemented.");
    }

    public String getWholeText() {
        throw new UnsupportedOperationException("DomText.getWholeText is not yet implemented.");
    }

    public Text replaceWholeText(String content) throws DOMException {
        throw new UnsupportedOperationException("DomText.replaceWholeText is not yet implemented.");
    }

    public String asText() {
        String text = this.getData();
        if (!(this.getParentNode() instanceof HtmlTextArea)) {
            text = DomText.reduceWhitespace(text);
        }
        return text;
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return NODE_NAME;
    }

    protected void printXml(String indent, PrintWriter printWriter) {
        if (this.getData().trim().length() != 0) {
            printWriter.print(indent);
            printWriter.println(StringUtils.escapeXmlChars(this.getData()));
        }
        this.printChildrenAsXml(indent, printWriter);
    }

    public String toString() {
        return this.asText();
    }

    protected boolean isTrimmedText() {
        return false;
    }
}

