/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.freebxml.omar.common.BindingUtility;
import org.freebxml.omar.common.CommonProperties;
import org.freebxml.omar.common.CredentialInfo;
import org.freebxml.omar.common.RegistryResponseHolder;
import org.freebxml.omar.common.security.SoapSecurityUtil;
import org.oasis.ebxml.registry.bindings.rs.RegistryResponseType;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SOAPMessenger {
    private String endpoint;
    private CredentialInfo credentialInfo = null;
    private BindingUtility bindingUtil = BindingUtility.getInstance();
    private Log log = LogFactory.getLog((Class)(class$org$freebxml$omar$common$SOAPMessenger == null ? (class$org$freebxml$omar$common$SOAPMessenger = SOAPMessenger.class$("org.freebxml.omar.common.SOAPMessenger")) : class$org$freebxml$omar$common$SOAPMessenger));
    static /* synthetic */ Class class$org$freebxml$omar$common$SOAPMessenger;
    static /* synthetic */ Class class$java$lang$String;

    public SOAPMessenger(String registryUrl, CredentialInfo credentialInfo) {
        this.endpoint = registryUrl;
        this.credentialInfo = credentialInfo;
    }

    void dumpMessage(String info, SOAPMessage msg) throws SOAPException {
        if (this.log.isTraceEnabled()) {
            if (info != null) {
                System.err.print(info);
            }
            try {
                msg.writeTo((OutputStream)System.err);
                System.err.println();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public RegistryResponseHolder sendSoapRequest(String requestString) throws JAXRException {
        return this.sendSoapRequest(requestString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryResponseHolder sendSoapRequest(String requestString, HashMap attachments) throws JAXRException {
        boolean logRequests = Boolean.valueOf(CommonProperties.getInstance().getProperty("omar.common.soapMessenger.logRequests", "false"));
        if (logRequests) {
            PrintStream requestLogPS = null;
            try {
                requestLogPS = new PrintStream(new FileOutputStream(File.createTempFile("SOAPMessenger_requestLog", ".xml")));
                requestLogPS.println(requestString);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (requestLogPS != null) {
                    requestLogPS.close();
                }
            }
        }
        if (requestString.startsWith("<?xml")) {
            requestString = requestString.substring(requestString.indexOf("?>") + 2).trim();
        }
        StringBuffer soapText = new StringBuffer("<soap-env:Envelope xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        soapText.append("<soap-env:Header/>");
        soapText.append("<soap-env:Body>");
        soapText.append(requestString);
        soapText.append("</soap-env:Body>");
        soapText.append("</soap-env:Envelope>");
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("requestString=\"" + requestString + "\""));
        }
        try {
            SOAPFault fault;
            ByteArrayInputStream soapStream = new ByteArrayInputStream(soapText.toString().getBytes("utf-8"));
            MessageFactory factory = MessageFactory.newInstance();
            SOAPMessage msg = factory.createMessage();
            SOAPPart soapPart = msg.getSOAPPart();
            soapPart.setContent((Source)new StreamSource(soapStream));
            if (attachments != null && !attachments.isEmpty()) {
                this.addAttachments(msg, attachments);
            }
            if (this.credentialInfo != null) {
                SoapSecurityUtil.getInstance().signSoapMessage(msg, this.credentialInfo);
            }
            SOAPMessage response = this.send(msg);
            if (this.credentialInfo != null && this.isSessionExpired(response)) {
                this.credentialInfo.sessionId = null;
            }
            if ((fault = response.getSOAPBody().getFault()) != null) {
                System.out.println(" fault.getFaultString(): " + fault.getFaultString());
                throw this.createRegistryException(fault);
            }
            Reader reader = this.processResponseBody(response, "Response");
            RegistryResponseType ebResponse = null;
            try {
                Object obj = BindingUtility.getInstance().getJAXBContext().createUnmarshaller().unmarshal(new InputSource(reader));
                ebResponse = (RegistryResponseType)obj;
            }
            catch (Exception x) {
                this.log.error((Object)"Failed to unmarshal server response.", (Throwable)x);
                throw new JAXRException("Invalid registry server response");
            }
            HashMap responseAttachments = this.processResponseAttachments(response);
            return new RegistryResponseHolder(ebResponse, responseAttachments);
        }
        catch (UnsupportedEncodingException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (MessagingException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (FileNotFoundException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (SOAPException x) {
            x.printStackTrace();
            throw new JAXRException("Error. Cannot connect to specified URL. Please check the URL and try again.", (Throwable)x);
        }
        catch (TransformerConfigurationException x) {
            throw new JAXRException((Throwable)x);
        }
        catch (TransformerException x) {
            throw new JAXRException((Throwable)x);
        }
    }

    private void addAttachments(SOAPMessage msg, HashMap attachments) throws MessagingException, FileNotFoundException, RegistryException {
        Iterator it = attachments.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String id = (String)entry.getKey();
            DataHandler dh = (DataHandler)entry.getValue();
            this.addAttachment(msg, id, dh);
        }
    }

    private void addAttachment(SOAPMessage msg, String id, DataHandler dh) throws FileNotFoundException, MessagingException, RegistryException {
        String cid = SoapSecurityUtil.convertUUIDToContentId(id);
        AttachmentPart ap = msg.createAttachmentPart(dh);
        ap.setContentId(cid);
        msg.addAttachmentPart(ap);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("adding attachment: contentId=" + cid));
        }
    }

    RegistryException createRegistryException(SOAPFault fault) {
        RegistryException result;
        block13: {
            result = null;
            System.out.println("createRegistryException:  fault.toString()" + fault.toString());
            String unknownError = "A unkown server side error occured, see debug log for details.";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)fault.toString());
            }
            if (fault.getFaultCode().startsWith("urn:oasis:names:tc:ebxml-regrep:rs:exception:")) {
                String exceptionName = fault.getFaultCode().substring("urn:oasis:names:tc:ebxml-regrep:rs:exception:".length());
                String exceptionMessage = fault.getFaultString();
                unknownError = "Exception:" + exceptionName + "\tFaultString:" + exceptionMessage;
                Detail detail = fault.getDetail();
                Iterator iter = detail.getDetailEntries();
                int i = 0;
                while (iter.hasNext()) {
                    DetailEntry detailEntry = (DetailEntry)iter.next();
                    unknownError = unknownError + " detailEntry[" + i++ + "] = " + detailEntry.toString();
                }
                try {
                    Class<?> exceptionClass = null;
                    try {
                        exceptionClass = Class.forName("org.freebxml.omar.common.exceptions." + exceptionName);
                    }
                    catch (ClassNotFoundException e) {
                        exceptionClass = Class.forName("javax.xml.registry." + exceptionName);
                    }
                    if (exceptionMessage != null) {
                        Class[] parameterDefinition = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SOAPMessenger.class$("java.lang.String")) : class$java$lang$String};
                        Constructor<?> exceptionConstructor = exceptionClass.getConstructor(parameterDefinition);
                        Object[] parameters = new Object[]{exceptionMessage};
                        result = (RegistryException)exceptionConstructor.newInstance(parameters);
                        break block13;
                    }
                    Class[] parameterDefinition = new Class[]{};
                    Constructor<?> exceptionConstructor = exceptionClass.getConstructor(parameterDefinition);
                    Object[] parameters = new Object[]{};
                    result = (RegistryException)exceptionConstructor.newInstance(parameters);
                }
                catch (ClassNotFoundException e) {
                    result = new RegistryException(unknownError, (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    result = new RegistryException(unknownError, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    result = new RegistryException(unknownError, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    result = new RegistryException(unknownError, (Throwable)e);
                }
                catch (InstantiationException e) {
                    result = new RegistryException(unknownError, (Throwable)e);
                }
            } else {
                result = new RegistryException(unknownError);
            }
        }
        return result;
    }

    SOAPMessage send(SOAPMessage msg) throws SOAPException {
        SOAPConnectionFactory scf = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = scf.createConnection();
        this.dumpMessage("Request=", msg);
        long t1 = System.currentTimeMillis();
        if (this.credentialInfo != null && this.credentialInfo.sessionId != null) {
            msg.getMimeHeaders().addHeader("Cookie", this.credentialInfo.sessionId);
        }
        SOAPMessage reply = connection.call(msg, (Object)this.endpoint);
        if (this.credentialInfo != null) {
            this.cacheSessionId(reply);
        }
        long t2 = System.currentTimeMillis();
        this.dumpMessage("Response=", reply);
        double secs = ((double)t2 - (double)t1) / 1000.0;
        this.log.debug((Object)("Call elapsed time in seconds: " + secs));
        return reply;
    }

    private boolean isSessionExpired(SOAPMessage message) {
        boolean sessionExpired = false;
        return sessionExpired;
    }

    private void cacheSessionId(SOAPMessage message) {
        MimeHeaders mimeHeaders = message.getMimeHeaders();
        String[] header = mimeHeaders.getHeader("Set-Cookie");
        if (header != null) {
            for (int i = 0; i < header.length; ++i) {
                if (!header[i].startsWith("JSESSIONID")) continue;
                String[] attributes = header[i].split(";");
                this.credentialInfo.sessionId = attributes[0];
                break;
            }
        }
    }

    Reader processResponseBody(SOAPMessage response, String lookFor) throws JAXRException, SOAPException, TransformerConfigurationException, TransformerException {
        String nodeLocalName;
        SOAPPart replyPart = response.getSOAPPart();
        Source replySource = replyPart.getContent();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer xFormer = tFactory.newTransformer();
        DOMResult domResult = new DOMResult();
        xFormer.transform(replySource, domResult);
        Node node = domResult.getNode();
        while (!(node == null || (nodeLocalName = node.getLocalName()) != null && nodeLocalName.endsWith(lookFor))) {
            node = SOAPMessenger.nextNode(node);
        }
        if (node == null) {
            node = domResult.getNode();
            while (!(node == null || (nodeLocalName = node.getLocalName()) != null && nodeLocalName.endsWith(lookFor))) {
                node = SOAPMessenger.nextNode(node);
            }
            throw new JAXRException("Could not find element '" + lookFor + "' in response");
        }
        return this.domNode2StringReader(node);
    }

    private static Node nextNode(Node node) {
        Node sib;
        Node child = node.getFirstChild();
        if (child != null) {
            return child;
        }
        while ((sib = node.getNextSibling()) == null) {
            if ((node = node.getParentNode()) != null) continue;
            return null;
        }
        return sib;
    }

    StringReader domNode2StringReader(Node node) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        StringWriter writer = null;
        Transformer serializer = tfactory.newTransformer();
        Properties oprops = new Properties();
        oprops.put("method", "xml");
        oprops.put("indent", "yes");
        serializer.setOutputProperties(oprops);
        writer = new StringWriter();
        serializer.transform(new DOMSource(node), new StreamResult(writer));
        String outString = writer.toString();
        StringReader reader = new StringReader(outString);
        return reader;
    }

    private HashMap processResponseAttachments(SOAPMessage response) throws JAXRException, SOAPException, MessagingException {
        if (response.countAttachments() == 0) {
            return null;
        }
        HashMap<String, DataHandler> attachMap = new HashMap<String, DataHandler>();
        Iterator it = response.getAttachments();
        while (it.hasNext()) {
            AttachmentPart ap = (AttachmentPart)it.next();
            String uuid = SoapSecurityUtil.convertContentIdToUUID(ap.getContentId());
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Processing attachment w/ contentId=" + uuid));
            }
            DataHandler dh = ap.getDataHandler();
            attachMap.put(uuid, dh);
        }
        return attachMap;
    }

    private boolean isSessionEstablished() {
        return false;
    }

    private void establishSession() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

