/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.soap;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.registry.JAXRException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class SOAPSender {
    private Log log = LogFactory.getLog((Class)(class$org$freebxml$omar$common$soap$SOAPSender == null ? (class$org$freebxml$omar$common$soap$SOAPSender = SOAPSender.class$("org.freebxml.omar.common.soap.SOAPSender")) : class$org$freebxml$omar$common$soap$SOAPSender));
    static /* synthetic */ Class class$org$freebxml$omar$common$soap$SOAPSender;

    public SOAPMessage send(SOAPMessage msg, String endpoint) throws SOAPException {
        SOAPConnectionFactory scf = SOAPConnectionFactory.newInstance();
        SOAPConnection connection = scf.createConnection();
        long t1 = System.currentTimeMillis();
        msg.saveChanges();
        this.dumpMessage("Request:", msg);
        SOAPMessage reply = connection.call(msg, (Object)endpoint);
        long t2 = System.currentTimeMillis();
        this.dumpMessage("Response:", reply);
        double secs = ((double)t2 - (double)t1) / 1000.0;
        this.log.debug((Object)("Call elapsed time in seconds: " + secs));
        return reply;
    }

    public SOAPMessage createSOAPMessage(Document bodyDoc) throws JAXRException {
        SOAPMessage msg = null;
        try {
            MessageFactory factory = MessageFactory.newInstance();
            msg = factory.createMessage();
            SOAPPart sp = msg.getSOAPPart();
            SOAPEnvelope se = sp.getEnvelope();
            SOAPBody sb = se.getBody();
            sb.addDocument(bodyDoc);
            msg.saveChanges();
        }
        catch (SOAPException e) {
            e.printStackTrace();
            throw new JAXRException("Error. Cannot connect to specified URL. Please check the URL and try again.", (Throwable)e);
        }
        return msg;
    }

    void dumpMessage(String info, SOAPMessage msg) throws SOAPException {
        if (info != null) {
            System.err.print(info);
        }
        try {
            msg.writeTo((OutputStream)System.err);
            System.err.println();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

