/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.props;

import java.util.regex.Pattern;
import org.apache.ant.props.RegexBasedEvaluator;
import org.apache.tools.ant.PropertyHelper;

public class LogicalOperationEvaluator
extends RegexBasedEvaluator {
    private static final String BOOL = "(?:true|false)";
    private static final String NEGATED_BOOL = "!(?:true|false)";
    private static final String EXPR = "(?:(?:true|false)|!(?:true|false))";
    private static final String AND = "[\\s]*(?:&|\\+)[\\s]*";
    private static final Pattern AND_PATTERN = Pattern.compile("[\\s]*(?:&|\\+)[\\s]*");
    private static final String XOR = "[\\s]*\\^[\\s]*";
    private static final Pattern XOR_PATTERN = Pattern.compile("[\\s]*\\^[\\s]*");
    private static final String OR = "[\\s]*\\|[\\s]*";
    private static final Pattern OR_PATTERN = Pattern.compile("[\\s]*\\|[\\s]*");
    private static final String OP = "(?:[\\s]*(?:&|\\+)[\\s]*|[\\s]*\\^[\\s]*|[\\s]*\\|[\\s]*)(?:(?:true|false)|!(?:true|false))";
    private static final String PATTERN = "^(?:(?:(?:true|false)|!(?:true|false))(?:[\\s]*(?:&|\\+)[\\s]*|[\\s]*\\^[\\s]*|[\\s]*\\|[\\s]*)(?:(?:true|false)|!(?:true|false))(?:(?:[\\s]*(?:&|\\+)[\\s]*|[\\s]*\\^[\\s]*|[\\s]*\\|[\\s]*)(?:(?:true|false)|!(?:true|false)))*)|!(?:true|false)$";

    public LogicalOperationEvaluator() {
        super(PATTERN);
    }

    protected Object evaluate(String[] groups, PropertyHelper propertyHelper) {
        boolean accumXor;
        boolean result = false;
        String[] or = OR_PATTERN.split(groups[0]);
        for (int o = 0; !result && o < or.length; result |= accumXor, ++o) {
            accumXor = false;
            String[] xor = XOR_PATTERN.split(or[o]);
            for (int x = 0; x < xor.length; ++x) {
                boolean b;
                boolean accumAnd = true;
                String[] and = AND_PATTERN.split(xor[x]);
                for (int a = 0; accumAnd && a < and.length; accumAnd &= b, ++a) {
                    boolean negate = false;
                    String expr = and[a];
                    if (expr.charAt(0) == '!') {
                        negate = true;
                        expr = expr.substring(1);
                    }
                    b = Boolean.valueOf(expr.trim().toLowerCase()) ^ negate;
                }
                accumXor ^= accumAnd;
            }
        }
        return result;
    }
}

