/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.util.Optional;
import java.util.concurrent.Flow;
import jdk.incubator.http.AbstractPushPublisher;
import jdk.incubator.http.internal.common.Log;

class BlockingPushPublisher<T>
extends AbstractPushPublisher<T> {
    volatile Subscription subscription;
    volatile Flow.Subscriber<? super T> subscriber;
    volatile AbstractPushPublisher.SubscriptionState state;
    long demand;

    BlockingPushPublisher() {
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.state = AbstractPushPublisher.SubscriptionState.OPENED;
        this.subscription = new Subscription(subscriber);
        subscriber.onSubscribe(this.subscription);
    }

    @Override
    public void acceptData(Optional<T> optional) throws InterruptedException {
        AbstractPushPublisher.SubscriptionState subscriptionState = this.state;
        if (subscriptionState == AbstractPushPublisher.SubscriptionState.CANCELLED) {
            return;
        }
        if (subscriptionState == AbstractPushPublisher.SubscriptionState.DONE) {
            throw new IllegalStateException("subscription complete");
        }
        if (!optional.isPresent()) {
            this.subscriber.onComplete();
            this.state = AbstractPushPublisher.SubscriptionState.DONE;
        } else {
            this.obtainPermit();
            if (this.state == AbstractPushPublisher.SubscriptionState.CANCELLED) {
                return;
            }
            this.subscriber.onNext(optional.get());
        }
    }

    @Override
    public void acceptError(Throwable throwable) {
        if (this.state != AbstractPushPublisher.SubscriptionState.OPENED) {
            Log.logError(throwable);
            return;
        }
        this.subscriber.onError(throwable);
        this.cancel();
    }

    private synchronized void obtainPermit() throws InterruptedException {
        while (this.demand == 0L) {
            this.wait();
        }
        if (this.state == AbstractPushPublisher.SubscriptionState.DONE) {
            throw new IllegalStateException("subscription complete");
        }
        --this.demand;
    }

    synchronized void addPermits(long l) {
        long l2 = this.demand;
        this.demand += l;
        if (l2 == 0L) {
            this.notifyAll();
        }
    }

    synchronized void cancel() {
        this.state = AbstractPushPublisher.SubscriptionState.CANCELLED;
        this.notifyAll();
    }

    private class Subscription
    implements Flow.Subscription {
        Subscription(Flow.Subscriber<? super T> subscriber) {
            BlockingPushPublisher.this.subscriber = subscriber;
        }

        @Override
        public void request(long l) {
            BlockingPushPublisher.this.addPermits(l);
        }

        @Override
        public void cancel() {
            BlockingPushPublisher.this.cancel();
        }
    }
}

