/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_holders.QNameHolder;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;
import java.math.*;

import javax.xml.rpc.holders.QNameHolder;
import javax.xml.namespace.QName;

import com.sun.javatest.Status;

public class Client extends ServiceEETest
{
    private Properties props = null;

    private final static QName myQName =
	new QName("http://someURI.org/", "someLocalPart");

    public static void main(String[] args)
    {
	Client theTests = new Client();
	Status s = theTests.run(args, System.out, System.err);
	s.exit();
    }


/*  Test setup */

  /*
     * @class.testArgs:     -ap jaxrpc-url-props.dat
   *   @class.setup_props:
   */

    public void setup(String[] args, Properties p) throws Fault
    {
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }

    /*
     *   @testName:  QNameHolderConstructorTest1
     *
     *   @assertion_ids: JAXRPC:JAVADOC:186;
     *                   WS4EE:SPEC:70;
     *
     *   @test_Strategy: Create instance via QNameHolder()
     *			 constructor. Verify QNameHolder object
     *			 created successfully.
     */
    public void QNameHolderConstructorTest1() throws Fault {
	TestUtil.logTrace("QNameHolderConstructorTest1");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via QNameHolder() ...");
	    QNameHolder n = new QNameHolder();
	    if (n != null) {
		TestUtil.logMsg(
		    "QNameHolder object created successfully");
	    }
	    else {
		TestUtil.logErr("QNameHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("QNameHolderConstructorTest1 failed", e);
        }

	if (!pass)
	    throw new Fault("QNameHolderConstructorTest1 failed");
    }

    /*
     *   @testName:  QNameHolderConstructorTest2
     *
     *   @assertion_ids: JAXRPC:JAVADOC:187;
     *                   WS4EE:SPEC:70;
     *
     *   @test_Strategy: Create instance via QNameHolder(QName)
     *			 constructor. Verify QNameHolder object
     *			 created successfully.
     */
    public void QNameHolderConstructorTest2() throws Fault {
	TestUtil.logTrace("QNameHolderConstructorTest2");
	boolean pass = true;
        try {
	    TestUtil.logMsg(
		"Create instance via QNameHolder(QName) ...");
	    QNameHolder n = new QNameHolder(myQName);
	    if (n != null) {
		TestUtil.logMsg(
		    "QNameHolder object created successfully");
	    }
	    else {
		TestUtil.logErr("QNameHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("QNameHolderConstructorTest2 failed", e);
        }

	if (!pass)
	    throw new Fault("QNameHolderConstructorTest2 failed");
    }

    /*
     *   @testName:  getValueTest
     *
     *   @assertion_ids: JAXRPC:JAVADOC:185;
     *                   WS4EE:SPEC:70;
     *
     *   @test_Strategy: Test using both constructors.
     *			 Verify value is set correct in each case.
     */
    public void getValueTest() throws Fault {
	TestUtil.logTrace("getValueTest");
	boolean pass = true;

	if (!getValueTest1()) pass = false;
	if (!getValueTest2()) pass = false;

	if (!pass)
	    throw new Fault("getValueTest failed");
    }

    /*
     * Create instance via QNameHolder().
     * Verify value is set to default.
     */
    private boolean getValueTest1() throws Fault {
	TestUtil.logTrace("getValueTest1");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Create instance via QNameHolder() ...");
	    QNameHolder n = new QNameHolder();
	    if (n != null) {
		QName v = n.value;
		if (v == null)
		    TestUtil.logMsg("Value set to null as expected");
		else {
		    TestUtil.logErr("Value: expected - null" +
					", received - " + v);
		    pass = false;
		}
	    }
	    else {
		TestUtil.logErr("QNameHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    pass = false;
        }

	return pass;

    }

    /*
     * Create instance via QNameHolder(QName).
     * Verify value is equal to what was set.
     */
    private boolean getValueTest2() throws Fault {
	TestUtil.logTrace("getValueTest2");
	boolean pass = true;
        try {
	    TestUtil.logMsg(
		"Create instance via QNameHolder(QName) ...");
	    QNameHolder n = new QNameHolder(myQName);
	    if (n != null) {
		QName v = n.value;
		if (v.equals(myQName))
		    TestUtil.logMsg("Value set as expected to "
			+ myQName);
		else {
		    TestUtil.logErr("Value: expected - " + myQName +
					", received - " + v);
		    pass = false;
		}
	    }
	    else {
		TestUtil.logErr("QNameHolder object not created");
		pass = false;
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    pass = false;
        }

	return pass;
    }
}
