/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1006;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import com.sun.javatest.Status;

import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPElement;
import java.util.Properties;
import java.util.Iterator;

/**
 * Tests R1006 in the WSI Basic Profile 1.0:
 * 	A MESSAGE MUST NOT contain soap:encodingStyle attributes on any element
 *  that is a child of soap:Body .
 */
public class Client extends ServiceEETest implements SOAPRequests{

    private W2JRLR1006Client client;

    /**
     * Test entry point.
     *
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }

    /**
     * @class.testArgs:     -ap jaxrpc-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void setup(String[] args, Properties properties) throws EETest.Fault {
        client = (W2JRLR1006Client)ClientFactory.getClient(W2JRLR1006Client.class, properties);
        logMsg("setup ok");
    }

    public void cleanup(){
        logMsg("cleanup");
    }

    /**
     * @testName: testNoEncodingStyleOnResponseBodyChildren
     *
     * @assertion_ids: JAXRPC:WSI:R1006
     *
     * @test_Strategy: Make a request and inspect response
     * soap:Body children to ensure they don't have soap:encodingStyle attribute.
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void testNoEncodingStyleOnResponseBodyChildren() throws EETest.Fault {
        SOAPMessage response = null;
        try{
            response = client.makeSaajRequest(HELLOWORLD_WITH_HANDLER);
        }catch(Exception e){
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try{
            validateNoEncodingStyleOnBodyChildren(response);
        }catch(SOAPException se){
            throw new EETest.Fault("Error creating response object", se);
        }
        client.logMessageInHarness(response);
    }

    /**
     * @testName: testNoEncodingStyleOnRequestBodyChildren
     *
     * @assertion_ids: JAXRPC:WSI:R1006
     *
     * @test_Strategy: Make a request and inspect request
     * soap:Body children to ensure they don't have soap:encodingStyle attribute.
     *
     * @throws com.sun.ts.lib.harness.EETest.Fault
     */
    public void testNoEncodingStyleOnRequestBodyChildren() throws EETest.Fault {
        String response = "";
        try{
            response = client.helloWorld();
        }catch(Exception e){
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        if(response.startsWith("failed")){
            throw new EETest.Fault(response);
        }
    }

    private void validateNoEncodingStyleOnBodyChildren(SOAPMessage response) throws EETest.Fault, SOAPException{
        Iterator bodyChildren = response.getSOAPPart().getEnvelope().getBody().getChildElements();
        SOAPElement child;
        String encodingStyle;
        while(bodyChildren.hasNext()){
            child = (SOAPElement)bodyChildren.next();
            encodingStyle = child.getEncodingStyle();
            if(!(encodingStyle == null || encodingStyle.equals(""))){
                client.logMessageInHarness(response);
                throw new EETest.Fault("Invalid element: child elements of soap:Body" +
                        " cannot have soap:encodingStyle attribute (BP-R1006):  " + child.getElementName().getQualifiedName());
            }
        }
    }
}
