/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR1016Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1016;

import com.sun.ts.tests.jaxrpc.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxrpc.wsi.constants.CTSConstants;
import com.sun.ts.lib.harness.EETest;

public class W2JRLR1016Client extends SOAPClient{

    public W2JRLR1016Client(String webServerHost, int port, int mode) throws EETest.Fault{
        super(webServerHost, port, mode);
        stubContext.setNamespace("http://simpletestservice.org/wsdl");
        stubContext.setService("SimpleTest");
        stubContext.setPortPrefix("SimpleEndpoint");
        stubContext.setServiceInterface(SimpleEndpoint.class);
    }

    protected String getEndpointURLProperty() {
        return CTSConstants.w2jrlr1016EndpointProperty;
    }

    protected String getWSDLURLProperty() {
        return CTSConstants.w2jrlr1016WSDLProperty;
    }

    public void alwaysThrowsServerException() throws Exception{
        ((SimpleEndpoint)stubContext.getStub()).alwaysThrowsServerException();
    }
}
