/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.props;

import java.util.Vector;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.util.regexp.Regexp;

public abstract class RegexBasedEvaluator
implements PropertyHelper.PropertyEvaluator {
    private String pattern;
    private RegularExpression regularExpression;
    private int options = 0;

    protected RegexBasedEvaluator() {
    }

    protected RegexBasedEvaluator(String pattern) {
        this.setPattern(pattern);
    }

    protected void addOption(int option) {
        this.options |= option;
    }

    public Object evaluate(String propertyName, PropertyHelper propertyHelper) {
        if ("ant.regexp.regexpimpl".equals(propertyName)) {
            return null;
        }
        Regexp regexp = this.getRegularExpression().getRegexp(propertyHelper.getProject());
        if (regexp.matches(propertyName)) {
            Vector groups = regexp.getGroups(propertyName, this.options);
            String[] s = groups.toArray(new String[groups.size()]);
            return this.evaluate(s, propertyHelper);
        }
        return null;
    }

    protected synchronized RegularExpression getRegularExpression() {
        if (this.regularExpression == null) {
            if (this.getPattern() == null) {
                throw new IllegalStateException("pattern not set");
            }
            this.regularExpression = new RegularExpression();
            this.regularExpression.setPattern(this.getPattern());
        }
        return this.regularExpression;
    }

    protected abstract Object evaluate(String[] var1, PropertyHelper var2);

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.regularExpression = null;
    }
}

