/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javasoft.sqe.apiCheck.API;
import javasoft.sqe.apiCheck.Main;
import javasoft.sqe.apiCheck.NamedList;
import javasoft.sqe.apiCheck.Props;
import javasoft.sqe.apiCheck.UFileWriter;
import javasoft.sqe.apiCheck.XClass;
import javasoft.sqe.apiCheck.XClassConstructor;
import javasoft.sqe.apiCheck.XClassField;
import javasoft.sqe.apiCheck.XClassMethod;
import javasoft.sqe.apiCheck.XModifier;
import javasoft.sqe.apiCheck.XPack;
import javasoft.sqe.apiCheck.XProg;
import javasoft.sqe.apiCheck.XProgWalk;
import javasoft.sqe.apiCheck.XType;
import javasoft.sqe.apiCheck.XTypeArray;
import javasoft.sqe.apiCheck.XTypeClass;
import javasoft.sqe.apiCheck.XTypes;

class WriteJh {
    static final String magic = "//Java signature file";
    PrintWriter os;
    String defpack = Main.args.getProperty("defpack");
    int defpacklength;
    String indent;
    boolean allflag = false;
    int acclevel = 0;
    static final String spec1 = "\b\t\n\f\r\"'\\";
    static final String spec2 = "btnfr\"'\\";

    WriteJh() {
        if (this.defpack != null) {
            if (this.defpack.length() == 0) {
                this.defpack = null;
            } else {
                if (!this.defpack.endsWith(".")) {
                    this.defpack = this.defpack + ".";
                }
                this.defpacklength = this.defpack.length();
            }
        }
        if (Main.args.getProperty("xpriv") != null) {
            this.acclevel = 2;
        }
    }

    void Close() {
        if (this.os != null) {
            this.os.flush();
            this.os.close();
            this.os = null;
        }
    }

    boolean Write(API api, String f) {
        String fname;
        if (f == null || (fname = f.trim()).length() == 0) {
            System.err.println("Missing destination file name");
            return false;
        }
        try {
            this.os = new PrintWriter(new UFileWriter(fname));
            this.Write(api);
            return true;
        }
        catch (IOException x) {
            System.err.println("Failed to open destination file " + fname);
            System.err.println(x);
            return false;
        }
    }

    boolean Write(API api, PrintStream s) {
        this.os = new PrintWriter(s);
        this.Write(api);
        return true;
    }

    void WriteAll(API api, PrintWriter pw) {
        this.os = pw;
        this.allflag = true;
        this.Write(api);
        this.allflag = false;
    }

    void Write(API api) {
        this.os.println(magic);
        this.OutProps(api.props);
        this.indent = "";
        this.Out(api.GetXProg().packs);
        this.os.println("\n//end of Java signature file");
    }

    void OutProps(Props props) {
        int i = 0;
        while (i < props.Size()) {
            this.os.println("//" + props.Key(i) + ": " + props.Value(i));
            ++i;
        }
        this.os.println("");
    }

    void OutInfo(XProg xprog) {
        this.os.println();
        this.os.println("/*");
        this.os.println();
        this.os.println("class types:");
        this.os.println();
        Enumeration e = xprog.typesclass.elements();
        while (e.hasMoreElements()) {
            this.os.print("\t");
            this.os.println((XTypeClass)e.nextElement());
        }
        this.os.println();
        this.os.println("array types:");
        this.os.println();
        Enumeration e2 = xprog.typesarray.elements();
        while (e2.hasMoreElements()) {
            this.os.print("\t");
            this.os.println((XTypeArray)e2.nextElement());
        }
        this.os.println();
        this.os.println("*/");
    }

    void OutExtern(XProg xprog) {
        OutExternWalk w = new OutExternWalk();
        w.Walk(xprog, null);
        int n = w.externs.size();
        if (n != 0) {
            Object[] tmp = new String[n];
            w.externs.toArray(tmp);
            Arrays.sort(tmp);
            this.os.println();
            this.os.println("/*");
            this.os.println("use");
            int i = 0;
            while (i < n) {
                this.os.print("\t");
                if (tmp[i] != null) {
                    this.os.print((String)tmp[i]);
                } else {
                    this.os.print("???");
                }
                this.os.println(i != n - 1 ? (char)',' : ';');
                ++i;
            }
            this.os.println("*/");
        }
    }

    void Out(XPack xpack) {
        Enumeration e;
        int n = 0;
        Enumeration e2 = xpack.classes.elements();
        while (e2.hasMoreElements()) {
            if (!((XClass)e2.nextElement()).defined) continue;
            ++n;
        }
        if (n != 0 || this.allflag) {
            if (xpack.name != null) {
                this.os.println();
                this.os.print("package ");
                this.os.print(xpack.FullName());
                this.os.println(";");
            }
            e = xpack.classes.elements();
            while (e.hasMoreElements()) {
                this.Out((XClass)e.nextElement());
            }
        }
        e = xpack.packs.elements();
        while (e.hasMoreElements()) {
            this.Out((XPack)e.nextElement());
        }
    }

    void Out(XClass xclass) {
        if (!xclass.defined && !this.allflag) {
            return;
        }
        if (XModifier.Access(xclass.modifier) < this.acclevel) {
            return;
        }
        this.os.println();
        this.os.print(this.indent);
        if (!xclass.defined) {
            this.os.print("/*unknown*/ class ");
            this.os.print(xclass.name);
        } else if (xclass.IsInterface()) {
            this.print(XModifier.toString(xclass.modifier & 0xFFFFFDFF));
            this.os.print("interface ");
            this.os.print(xclass);
            if (xclass.implement.size() != 0) {
                this.os.print(" extends ");
                this.OutClassNames(xclass.implement);
            }
        } else {
            this.print(XModifier.toString(xclass.modifier));
            this.os.print("class ");
            this.os.print(xclass);
            if (xclass.extend != null && !xclass.extend.FullName().equals("java.lang.Object")) {
                this.os.print(" extends ");
                this.os.print(this.ShortenClassName(xclass.extend.FullName()));
            }
            if (xclass.implement.size() != 0) {
                this.os.print(" implements ");
                this.OutClassNames(xclass.implement);
            }
        }
        this.os.print(" {");
        int first = 0;
        Enumeration e = xclass.constructors.elements();
        while (e.hasMoreElements()) {
            XClassConstructor xcons = (XClassConstructor)e.nextElement();
            if (XModifier.Access(xcons.modifier) < this.acclevel) continue;
            if (first++ == 0) {
                this.os.println();
            }
            this.os.print(this.indent);
            this.os.print("\t");
            this.print(XModifier.toString(xcons.modifier));
            this.os.print(xcons.name);
            this.os.print("(");
            this.OutClassNames(xcons.args);
            this.os.print(")");
            if (xcons.xthrows.size() != 0) {
                this.os.print(" throws ");
                this.OutClassNames(xcons.xthrows);
            }
            this.os.println(";");
        }
        Enumeration e2 = xclass.methods.elements();
        while (e2.hasMoreElements()) {
            XClassMethod xmethod = (XClassMethod)e2.nextElement();
            if (XModifier.Access(xmethod.modifier) < this.acclevel) continue;
            if (first++ == 0) {
                this.os.println();
            }
            this.os.print(this.indent);
            this.os.print("\t");
            int mods = xmethod.modifier;
            this.print(XModifier.toString(mods));
            this.os.print(this.ShortenClassName(xmethod.type.toString()));
            this.os.print(" ");
            this.os.print(xmethod.name);
            this.os.print("(");
            this.OutClassNames(xmethod.args);
            this.os.print(")");
            if (xmethod.xthrows.size() != 0) {
                this.os.print(" throws ");
                this.OutClassNames(xmethod.xthrows);
            }
            this.os.println(";");
        }
        Enumeration e3 = xclass.fields.elements();
        while (e3.hasMoreElements()) {
            XClassField xfield = (XClassField)e3.nextElement();
            if (XModifier.Access(xfield.modifier) < this.acclevel) continue;
            if (first++ == 0) {
                this.os.println();
            }
            this.os.print(this.indent);
            this.os.print("\t");
            int mods = xfield.modifier;
            this.print(XModifier.toString(mods));
            this.print(this.ShortenClassName(xfield.type.toString()));
            this.os.print(xfield.toString());
            this.OutValue(xfield);
            this.os.println(";");
        }
        Enumeration e4 = xclass.inners.elements();
        while (e4.hasMoreElements()) {
            XClass xinner = (XClass)e4.nextElement();
            if (XModifier.Access(xinner.modifier) < this.acclevel) continue;
            if (first++ == 0) {
                this.os.println();
            }
            this.indent = this.indent + "\t";
            this.Out(xinner);
            this.indent = this.indent.substring(0, this.indent.length() - 1);
        }
        if (first != 0) {
            this.os.print(this.indent);
        }
        this.os.println("}");
    }

    void OutClassNames(XTypes list) {
        int i = 0;
        while (i < list.size()) {
            if (i != 0) {
                this.os.print(", ");
            }
            this.os.print(this.ShortenClassName(((XType)list.elementAt(i)).toString()));
            ++i;
        }
    }

    void OutClassNames(NamedList list) {
        int i = 0;
        while (i < list.size()) {
            if (i != 0) {
                this.os.print(", ");
            }
            this.os.print(this.ShortenClassName(((XClass)list.elementAt(i)).FullName()));
            ++i;
        }
    }

    String ShortenClassName(String s) {
        if (this.defpack != null && s.startsWith(this.defpack) && s.indexOf(46, this.defpacklength) == -1) {
            return s.substring(this.defpacklength);
        }
        return s;
    }

    void OutValue(XClassField xfield) {
        if (xfield.value != null) {
            this.os.print("=" + WriteJh.Value(xfield.value));
        }
    }

    void print(String s) {
        if (s.length() != 0) {
            this.os.print(s);
            this.os.print(" ");
        }
    }

    void print(String s1, String s2) {
        if (s2.length() != 0) {
            this.os.print(s1);
            this.os.print(s2);
        }
    }

    static String Value(Object value) {
        String s = null;
        if (value instanceof Character) {
            s = "'" + WriteJh.StuffOut(value.toString()) + "'";
        } else if (value instanceof String) {
            s = "\"" + WriteJh.StuffOut(value.toString()) + "\"";
        } else if (value instanceof Long) {
            s = value.toString() + "L";
        } else if (value instanceof Float) {
            Float f = (Float)value;
            s = f.toString();
            if (!f.isNaN() && !f.isInfinite()) {
                s = s + "f";
            }
        } else if (value instanceof Double) {
            Double d = (Double)value;
            s = d.toString();
            if (!d.isNaN() && !d.isInfinite()) {
                s = s + "d";
            }
        } else {
            s = value.toString();
        }
        return s;
    }

    static String StuffOut(String s) {
        StringBuffer x = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            int k = spec1.indexOf(c);
            if (k >= 0) {
                x.append('\\').append(spec2.charAt(k));
            } else if (c < ' ') {
                x.append(UFileWriter.Esc(c));
            } else {
                x.append(c);
            }
            ++i;
        }
        return x.toString();
    }

    static {
        magic = magic;
        spec1 = spec1;
        spec2 = spec2;
    }

    static class OutExternWalk
    extends XProgWalk {
        Vector externs = new Vector();

        OutExternWalk() {
        }

        void Walk(XClass x) {
            if (!x.defined) {
                this.externs.add(x.FullName());
            } else {
                super.Walk(x);
            }
        }
    }
}

