/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ContextProvider.java 70021 2013-02-14 09:30:04Z supol $ 
 */

package com.sun.ts.tests.jaxrs.api.client.clientresponsecontext;

import java.io.IOException;

import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;

import com.sun.ts.lib.harness.EETest.Fault;

@Provider
@Priority(Integer.MIN_VALUE)
public class ContextProvider implements ClientResponseFilter {

	protected void checkFilterContext(ClientRequestContext requestContext,
			ClientResponseContext responseContext) throws Fault {
		throw new Fault("this TCK method is not implemented yet");
	}

	@Override
	public void filter(ClientRequestContext requestContext,
			ClientResponseContext responseContext) throws IOException {
		try {
			checkFilterContext(requestContext, responseContext);
		} catch (Fault e) {
			throw new IOException(e);
		}

	}

}
