/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringDataSource.java 69447 2013-01-10 12:49:03Z supol $ 
 */

package com.sun.ts.tests.jaxrs.common.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

import javax.activation.DataSource;
import javax.ws.rs.core.MediaType;

public class StringDataSource implements DataSource {
	
	private String value;
	private MediaType mediaType;

	public StringDataSource(String value, MediaType mediaType) {
		super();
		this.value = value;
		this.mediaType = mediaType;
	}

	@Override
	public String getContentType() {
		return mediaType.getType() + "/" + mediaType.getSubtype();
	}

	@Override
	public InputStream getInputStream() throws IOException {
		ByteArrayInputStream bais = new ByteArrayInputStream(value.getBytes()); 
		return bais;
	}

	@Override
	public String getName() {
		return value;
	}

	@Override
	public OutputStream getOutputStream() throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream(value.length());
		OutputStreamWriter osw = new OutputStreamWriter(baos);
		osw.write(value);
		return baos;
	}

}
