/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */
package com.sun.ts.tests.jaxrs.ee.rs.produceconsume;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response.Status;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
public class JAXRSClient extends JAXRSCommonClient {

	private static final long serialVersionUID = 3927081991341346347L;

	public JAXRSClient() {
		setContextRoot("/jaxrs_ee_rs_produceconsume_web/resource");
	}

	/**
	 * Entry point for different-VM execution.  It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}

	/* Run test */
	/*
	 * @testName: anyPlainTest
	 * @assertion_ids: JAXRS:SPEC:21; JAXRS:SPEC:26.6; JAXRS:SPEC:25.8;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Produces does not match the 
	 * 					request Accept header.
	 * 					test accept *//* @produces text/plain 
							*/
	public void anyPlainTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.GET, "plain"));
		setProperty(Property.SEARCH_STRING, MediaType.TEXT_PLAIN);
		invoke();
	}

	/*
	 * @testName: anyWidgetsxmlTest
	 * @assertion_ids: JAXRS:SPEC:21; JAXRS:SPEC:26.6; JAXRS:SPEC:25.8;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Produces does not match the 
	 * 					request Accept header.
	 * 					test accept *//* @produces text/plain 
							*/
	public void anyWidgetsxmlTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.GET, "widgetsxml"));
		setProperty(Property.SEARCH_STRING, Resource.WIDGETS_XML);
		invoke();
	}

	/*
	 * @testName: anyUnknownTest
	 * @assertion_ids: JAXRS:SPEC:21; JAXRS:SPEC:26.6; JAXRS:SPEC:25.8;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Produces does not match the 
	 * 					request Accept header.
	 * 					test accept *//* @produces unknown/unknown 
							*/
	public void anyUnknownTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.GET, "unknown"));
		setProperty(Property.SEARCH_STRING, Resource.UNKNOWN);
		invoke();
	}

	/*
	 * @testName: widgetsXmlAnyTest
	 * @assertion_ids: JAXRS:SPEC:21; JAXRS:SPEC:25.8;
	 * 					JAXRS:JAVADOC:10;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Produces does not match the 
	 * 					request Accept header.
	 * 					test accept text/plain @produces *.* 
	*/
	public void widgetsXmlAnyTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS, "Accept: " + Resource.WIDGETS_XML);
		setProperty(Property.REQUEST, buildRequest(Request.GET, "any"));
		setProperty(Property.SEARCH_STRING, MediaType.WILDCARD);
		invoke();
	}

	/*
	 * @testName: plainAnyTest
	 * @assertion_ids: JAXRS:SPEC:21; JAXRS:SPEC:25.8;
	 * 					JAXRS:JAVADOC:10;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Produces does not match the 
	 * 					request Accept header.
	 * 					test accept text/plain @produces *.* 
	*/
	public void plainAnyTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS,
				buildAccept(MediaType.TEXT_PLAIN_TYPE));
		setProperty(Property.REQUEST, buildRequest(Request.GET, "any"));
		setProperty(Property.SEARCH_STRING, MediaType.WILDCARD);
		invoke();
	}

	/*
	 * @testName: unknownAnyTest
	 * @assertion_ids: JAXRS:SPEC:21; JAXRS:SPEC:25.8;
	 * 					JAXRS:JAVADOC:10;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Produces does not match the 
	 * 					request Accept header.
	 * 					test accept unknown/unknown @produces *.* 
	*/
	public void unknownAnyTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS, "Accept: " + Resource.UNKNOWN);
		setProperty(Property.REQUEST, buildRequest(Request.GET, "any"));
		setProperty(Property.SEARCH_STRING, MediaType.WILDCARD);
		invoke();
	}

	/*
	 * @testName: htmlPlainTest
	 * @assertion_ids: JAXRS:SPEC:21; JAXRS:SPEC:26.7;
	 * 					JAXRS:JAVADOC:10;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Produces does not match the 
	 * 					request Accept header.
	 * 					test accept text/plain @produces text/html 
	*/
	public void htmlPlainTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS,
				buildAccept(MediaType.TEXT_HTML_TYPE));
		setProperty(Property.REQUEST, buildRequest(Request.GET, "plain"));
		setProperty(Property.STATUS_CODE, getStatusCode(Status.NOT_ACCEPTABLE));
		invoke();
	}

	/*
	 * @testName: htmlUnknownTest
	 * @assertion_ids: JAXRS:SPEC:21; JAXRS:SPEC:26.7;
	 * 					JAXRS:JAVADOC:10;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Produces does not match the 
	 * 					request Accept header.
	 * 					test accept text/plain @produces unknown/unknown 
	*/
	public void htmlUnknownTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS,
				buildAccept(MediaType.TEXT_HTML_TYPE));
		setProperty(Property.REQUEST, buildRequest(Request.GET, "plain"));
		setProperty(Property.STATUS_CODE, getStatusCode(Status.NOT_ACCEPTABLE));
		invoke();
	}

	/*
	 * @testName: plainPlusProducePlainTest
	 * @assertion_ids: JAXRS:SPEC:22; JAXRS:SPEC:25.8;
	 * 					JAXRS:JAVADOC:1; JAXRS:JAVADOC:10;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Accept header.
	 * 					accept text/plain @Consumes text/plain+xml 
	*/
	public void plainPlusProducePlainTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS,
				buildAccept(MediaType.TEXT_PLAIN_TYPE));
		setProperty(Property.REQUEST_HEADERS,
				buildContentType(MediaType.TEXT_PLAIN_TYPE));
		setProperty(Property.REQUEST, buildRequest(Request.POST, "plus"));
		setProperty(Property.SEARCH_STRING, MediaType.TEXT_PLAIN);
		invoke();
	}

	/*
	 * @testName: plainPlusProduceXmlTest
	 * @assertion_ids: JAXRS:SPEC:22; JAXRS:SPEC:25.8;
	 * 					JAXRS:JAVADOC:1; JAXRS:JAVADOC:10;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Accept header.
	 * 					accept text/plain @Consumes text/plain+xml 
	*/
	public void plainPlusProduceXmlTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS,
				buildAccept(MediaType.TEXT_XML_TYPE));
		setProperty(Property.REQUEST_HEADERS,
				buildContentType(MediaType.TEXT_XML_TYPE));
		setProperty(Property.REQUEST, buildRequest(Request.POST, "plus"));
		setProperty(Property.SEARCH_STRING, MediaType.TEXT_XML);
		invoke();
	}

	// ----------------------------------------------------------------------
	/*
	 * @testName: anyPlainConsumesTest
	 * @assertion_ids: JAXRS:SPEC:22; JAXRS:SPEC:25.7;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Content-Type header.
	 * 					test content-type *//* @Consumes text/plain 
								*/
	public void anyPlainConsumesTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.POST, "plain"));
		setProperty(Property.SEARCH_STRING, MediaType.TEXT_PLAIN);
		invoke();
	}

	/*
	 * @testName: anyWidgetsxmlConsumesTest
	 * @assertion_ids: JAXRS:SPEC:22; JAXRS:SPEC:25.7;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Content-Type header.
	 * 					test content-type *//* @Consumes text/plain 
							*/
	public void anyWidgetsxmlConsumesTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.POST, "widgetsxml"));
		setProperty(Property.SEARCH_STRING, Resource.WIDGETS_XML);
		invoke();
	}

	/*
	 * @testName: anyUnknownConsumesTest
	 * @assertion_ids: JAXRS:SPEC:22; JAXRS:SPEC:25.7
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Content-Type header.
	 * 					test content-type *//* @Consumes unknown/unknown 
							*/
	public void anyUnknownConsumesTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.POST, "unknown"));
		setProperty(Property.SEARCH_STRING, Resource.UNKNOWN);
		invoke();
	}

	/*
	 * @testName: widgetsXmlAnyConsumesTest
	 * @assertion_ids: JAXRS:SPEC:22; JAXRS:SPEC:25.7;
	 * 					JAXRS:JAVADOC:1;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Content-Type header.
	 * 					test content-type text/plain @Consumes *.* 
	*/
	public void widgetsXmlAnyConsumesTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS, "Content-Type: " +
				Resource.WIDGETS_XML);
		setProperty(Property.REQUEST, buildRequest(Request.POST, "any"));
		setProperty(Property.SEARCH_STRING, MediaType.WILDCARD);
		invoke();
	}

	/*
	 * @testName: plainAnyConsumesTest
	 * @assertion_ids: JAXRS:SPEC:22; JAXRS:SPEC:25.7;
	 * 					JAXRS:JAVADOC:1;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Content-Type header.
	 * 					test content-type text/plain @Consumes *.* 
	*/
	public void plainAnyConsumesTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS,
				buildContentType(MediaType.TEXT_PLAIN_TYPE));
		setProperty(Property.REQUEST, buildRequest(Request.POST, "any"));
		setProperty(Property.SEARCH_STRING, MediaType.WILDCARD);
		invoke();
	}

	/*
	 * @testName: unknownAnyConsumesTest
	 * @assertion_ids: JAXRS:SPEC:22; JAXRS:SPEC:25.7;
	 * 					JAXRS:JAVADOC:1;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Content-Type header.
	 * 					test content-type unknown/unknown @Consumes *.* 
	*/
	public void unknownAnyConsumesTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS, "Content-type: " +
				Resource.UNKNOWN);
		setProperty(Property.REQUEST, buildRequest(Request.POST, "any"));
		setProperty(Property.SEARCH_STRING, MediaType.WILDCARD);
		invoke();
	}

	/*
	 * @testName: htmlPlainConsumesTest
	 * @assertion_ids: JAXRS:SPEC:22; 
	 * 					JAXRS:JAVADOC:1;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Content-Type header.
	 * 					test content-type text/html @Consumes text/plain 
	*/
	public void htmlPlainConsumesTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS,
				buildContentType(MediaType.TEXT_HTML_TYPE));
		setProperty(Property.REQUEST, buildRequest(Request.POST, "plain"));
		setProperty(Property.STATUS_CODE,
				getStatusCode(Status.UNSUPPORTED_MEDIA_TYPE));
		invoke();
	}

	/*
	 * @testName: htmlUnknownConsumesTest
	 * @assertion_ids: JAXRS:SPEC:22; 
	 * 					JAXRS:JAVADOC:1;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Content-Type header.
	 * 					test content-type text/html @Consumes text/plain 
	*/
	public void htmlUnknownConsumesTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS,
				buildContentType(MediaType.TEXT_HTML_TYPE));
		setProperty(Property.REQUEST, buildRequest(Request.POST, "plain"));
		setProperty(Property.STATUS_CODE,
				getStatusCode(Status.UNSUPPORTED_MEDIA_TYPE));
		invoke();
	}

	/*
	 * @testName: plainPlusConsumePlainTest
	 * @assertion_ids: JAXRS:SPEC:22; JAXRS:SPEC:25.7;
	 *					JAXRS:JAVADOC:1;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Content-Type header.
	 * 					content-type text/plain @Consumes text/plain+xml 
	*/
	public void plainPlusConsumePlainTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS,
				buildContentType(MediaType.TEXT_PLAIN_TYPE));
		setProperty(Property.REQUEST, buildRequest(Request.POST, "plus"));
		setProperty(Property.SEARCH_STRING, MediaType.TEXT_PLAIN);
		invoke();
	}

	/*
	 * @testName: plainPlusConsumeXmlTest
	 * @assertion_ids: JAXRS:SPEC:22; JAXRS:SPEC:25.7;
	 * 					JAXRS:JAVADOC:1;
	 * @test_Strategy: An implementation MUST NOT invoke a method whose 
	 * 					effective value of @Consumes does not match the 
	 * 					request Content-Type header.
	 * 					content-type text/plain @Consumes text/plain+xml 
	*/
	public void plainPlusConsumeXmlTest() throws Fault {
		setProperty(Property.REQUEST_HEADERS,
				buildContentType(MediaType.TEXT_XML_TYPE));
		setProperty(Property.REQUEST, buildRequest(Request.POST, "plus"));
		setProperty(Property.SEARCH_STRING, MediaType.TEXT_XML);
		invoke();
	}
}
