/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */
package com.sun.ts.tests.jaxrs.ee.rs.produceconsume;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;

@Path("resource")
public class Resource {

	public static final String WIDGETS_XML = "application/widgets+xml";
	public static final String UNKNOWN = "unknown/unknown";

	@GET
	@Path("plain")
	@Produces(MediaType.TEXT_PLAIN)
	public String pPlain() {
		return MediaType.TEXT_PLAIN;
	}

	@GET
	@Path("html")
	@Produces(MediaType.TEXT_HTML)
	public String pHtml() {
		return MediaType.TEXT_HTML;
	}

	@GET
	@Path("widgetsxml")
	@Produces(WIDGETS_XML)
	public String pWidgetxml() {
		return WIDGETS_XML;
	}

	@GET
	@Path("unknown")
	@Produces(UNKNOWN)
	public String pUnknown() {
		return UNKNOWN;
	}

	@GET
	@Path("any")
	@Produces(MediaType.WILDCARD)
	public String pAny() {
		return MediaType.WILDCARD;
	}

	@POST
	@Path("plain")
	@Consumes(MediaType.TEXT_PLAIN)
	public String cPlain() {
		return MediaType.TEXT_PLAIN;
	}

	@POST
	@Path("html")
	@Consumes(MediaType.TEXT_HTML)
	public String cHtml() {
		return MediaType.TEXT_HTML;
	}

	@POST
	@Path("widgetsxml")
	@Consumes(WIDGETS_XML)
	public String cWidgetxml() {
		return WIDGETS_XML;
	}

	@POST
	@Path("unknown")
	@Consumes(UNKNOWN)
	public String cUnknown() {
		return UNKNOWN;
	}

	@POST
	@Path("any")
	@Consumes(MediaType.WILDCARD)
	public String cAny() {
		return MediaType.WILDCARD;
	}

	@POST
	@Path("plus")
	@Produces(MediaType.TEXT_PLAIN + "," + MediaType.TEXT_XML)
	@Consumes(MediaType.TEXT_PLAIN + "," + MediaType.TEXT_XML)
	public String plus(@Context HttpHeaders headers) {
		return headers.getMediaType() == null ? "null" : headers.getMediaType()
				.toString();
	}
}
