/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: JAXRSClient.java 69694 2013-01-30 14:54:06Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.globalbinding;

import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;

/*
 * @class.setup_props: webServerHost;
 *                     webServerPort;
 *                     ts_home;
 */
/**
 * Test the interceptor is called when any entity provider is called
 */
public class JAXRSClient extends JaxrsCommonClient {

	private static final long serialVersionUID = -3785330089447087404L;

	public JAXRSClient() {
		setContextRoot("/jaxrs_spec_filter_globalbinding_web/resource");
	}

	/**
	 * Entry point for different-VM execution. It should delegate to method
	 * run(String[], PrintWriter, PrintWriter), and this method should not
	 * contain any test configuration.
	 */
	public static void main(String[] args) {
		new JAXRSClient().run(args);
	}

	/* Run test */

	/*
	 * @testName: nameBoundResourceTest
	 * @assertion_ids: JAXRS:SPEC:89; 
	 * @test_Strategy: If providers are decorated with at least one name binding 
	 * 					annotation, the application subclass must be annotated as 
	 * 					shown above in order for those filters or interceptors 
	 * 					to be globally bound
	 */
	public void nameBoundResourceTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.POST, "bind"));
		setProperty(Property.CONTENT, "0");
		setProperty(Property.SEARCH_STRING, "12");
		invoke();
		logMsg("Bound as expected");
	}
	
	/*
	 * @testName: globalBoundResourceTest
	 * @assertion_ids: JAXRS:SPEC:89; 
	 * @test_Strategy: If providers are decorated with at least one name binding 
	 * 					annotation, the application subclass must be annotated as 
	 * 					shown above in order for those filters or interceptors 
	 * 					to be globally bound
	 */
	public void globalBoundResourceTest() throws Fault {
		setProperty(Property.REQUEST, buildRequest(Request.POST, "nobind"));
		setProperty(Property.CONTENT, "0");
		setProperty(Property.SEARCH_STRING, "12");
		invoke();
		logMsg("Bound as expected");
	}	

}
